/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.cosmology;

import info.thereisonlywe.core.essentials.LanguageEssentials;
import info.thereisonlywe.core.essentials.LocaleEssentials;

public enum Sphere {
    _1(12000),
    _2(11000),
    _3(10000),
    _4(9000),
    _5(8000),
    _6(7000),
    _7(6000);

    public final int daysToRevolve;

    private Sphere(int daysToRevolve) {
        this.daysToRevolve = daysToRevolve;
    }

    public String getName(String lang) {
        int number = Integer.parseInt(this.name().replace("_", ""));
        if (lang.equals("tr")) {
            return String.valueOf(number) + ". Felek";
        }
        return String.valueOf(number) + LanguageEssentials.English.getNumberOrderSuffix(number) + " Sphere";
    }

    public String toString() {
        return this.getName(LocaleEssentials.LANGUAGE_DEFAULT);
    }
}

