/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.essentials;

import info.thereisonlywe.core.cosmology.Planet;
import info.thereisonlywe.core.cosmology.ZodiacAspect;
import info.thereisonlywe.core.cosmology.ZodiacDegree;
import info.thereisonlywe.core.cosmology.ZodiacMansion;
import info.thereisonlywe.core.cosmology.ZodiacSign;
import info.thereisonlywe.core.essentials.MathEssentials;
import info.thereisonlywe.core.objects.CircularArray;
import info.thereisonlywe.core.objects.NumberRange;
import info.thereisonlywe.core.ontology.DivineName;
import info.thereisonlywe.core.ontology.Element;
import info.thereisonlywe.core.ontology.Gender;
import info.thereisonlywe.core.ontology.Letter;
import info.thereisonlywe.core.ontology.Manifestation;
import info.thereisonlywe.core.ontology.Modality;
import info.thereisonlywe.core.ontology.Temperament;
import info.thereisonlywe.core.ontology.Word;
import java.util.ArrayList;
import java.util.List;

public class EsotericEssentials {
    public static Word asDivineWord(long number) {
        ArrayList<Integer> arrayList = MathEssentials.toNumberBase(28, number);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < arrayList.size()) {
            int index = arrayList.get(i);
            index = index == 0 ? 27 : index - 1;
            sb.append(Letter.values()[index].toString());
            ++i;
        }
        return new Word(sb.toString());
    }

    public static ZodiacMansion asZodiacMansion(Letter letter) {
        return ZodiacMansion.values()[letter.ordinal()];
    }

    public static ZodiacMansion asZodiacMansion(long number) {
        return EsotericEssentials.getZodiacMansion(EsotericEssentials.asZodiacDegree(number));
    }

    public static ZodiacMansion asZodiacMansion(ZodiacDegree deg) {
        return EsotericEssentials.getZodiacMansion(deg);
    }

    public static Letter asLetter(long number) {
        return Letter.values()[EsotericEssentials.getZodiacMansion(EsotericEssentials.asZodiacDegree(number)).ordinal()];
    }

    public static Letter asLetter(ZodiacDegree deg) {
        return Letter.values()[EsotericEssentials.getZodiacMansion(deg).ordinal()];
    }

    public static ZodiacMansion asZodiacMansion(String phrase) {
        return EsotericEssentials.getZodiacMansion(EsotericEssentials.asZodiacDegree(phrase));
    }

    public static long asNumber(Word word) {
        int[] values = new int[word.length()];
        int i = 0;
        while (i < word.length()) {
            char c = word.charAt(i);
            values[i] = Letter.valueOf(c).ordinal() + 1;
            if (values[i] == 28) {
                values[i] = 0;
            }
            ++i;
        }
        return MathEssentials.fromNumberBase(28, values);
    }

    public static boolean aspects(double point1, double point2, ZodiacAspect aspect, double orb) {
        double raw = (point1 = EsotericEssentials.normalizeZodiacDegree(point1)) >= (point2 = EsotericEssentials.normalizeZodiacDegree(point2)) ? point1 - point2 : point2 - point1;
        double min = raw - orb + 360.0;
        double max = raw + orb + 360.0;
        NumberRange pr = new NumberRange(min, max);
        NumberRange pr2 = new NumberRange(min - 360.0, max - 360.0);
        return pr.isInRange(aspect.angle + 360.0) || pr2.isInRange(360.0 - aspect.angle);
    }

    public static boolean aspects(ZodiacDegree deg1, ZodiacDegree deg2, ZodiacAspect aspect, double orb) {
        return EsotericEssentials.aspects(deg1.degree, deg2.degree, aspect, orb);
    }

    public static ZodiacDegree asZodiacDegree(long number) {
        int n = (int)(number % 360L);
        int t = n / 12;
        n %= 12;
        if ((n += 5) >= 12) {
            n -= 12;
        }
        return new ZodiacDegree(ZodiacSign.values()[n], t % 30);
    }

    public static ZodiacDegree asZodiacDegree(String phrase) {
        return EsotericEssentials.asZodiacDegree(phrase.split(" "));
    }

    public static ZodiacSign asZodiacSign(long number) {
        return EsotericEssentials.asZodiacDegree((long)number).zodiacSign;
    }

    public static ZodiacSign asZodiacSign(String phrase) {
        return EsotericEssentials.asZodiacDegree((String)phrase).zodiacSign;
    }

    public static List<ZodiacAspect> getAspects(double point1, double point2, double orb) {
        point1 = EsotericEssentials.normalizeZodiacDegree(point1);
        point2 = EsotericEssentials.normalizeZodiacDegree(point2);
        ArrayList<ZodiacAspect> result = new ArrayList<ZodiacAspect>();
        ZodiacAspect[] zodiacAspectArray = ZodiacAspect.ASPECTS;
        int n = ZodiacAspect.ASPECTS.length;
        int n2 = 0;
        while (n2 < n) {
            ZodiacAspect element = zodiacAspectArray[n2];
            if (EsotericEssentials.aspects(point1, point2, element, orb)) {
                result.add(element);
            }
            ++n2;
        }
        return result;
    }

    public static List<ZodiacAspect> getAspects(double point1, double point2, ZodiacAspect[] aspects, double orb) {
        point1 = EsotericEssentials.normalizeZodiacDegree(point1);
        point2 = EsotericEssentials.normalizeZodiacDegree(point2);
        ArrayList<ZodiacAspect> result = new ArrayList<ZodiacAspect>();
        ZodiacAspect[] zodiacAspectArray = aspects;
        int n = aspects.length;
        int n2 = 0;
        while (n2 < n) {
            ZodiacAspect element = zodiacAspectArray[n2];
            if (EsotericEssentials.aspects(point1, point2, element, orb)) {
                result.add(element);
            }
            ++n2;
        }
        return result;
    }

    public static List<ZodiacAspect> getAspects(ZodiacDegree deg1, ZodiacDegree deg2, double orb) {
        return EsotericEssentials.getAspects(deg1.degree, deg2.degree, orb);
    }

    public static List<ZodiacAspect> getAspects(ZodiacDegree deg1, ZodiacDegree deg2, ZodiacAspect[] aspects, double orb) {
        return EsotericEssentials.getAspects(deg1.degree, deg2.degree, aspects, orb);
    }

    public static final CircularArray<Planet> getChaldeanPlanetOrder() {
        return new CircularArray<Planet>(new Planet[]{Planet.SATURN, Planet.JUPITER, Planet.MARS, Planet.SUN, Planet.VENUS, Planet.MERCURY, Planet.MOON});
    }

    public static double getDegree(ZodiacSign baseSign, double offset) {
        return baseSign.degreeSpan.start + offset;
    }

    public static DivineName getDivineName(Letter l) {
        int i = 0;
        while (i < DivineName.values().length) {
            if (DivineName.values()[i].letter == l) {
                return DivineName.values()[i];
            }
            ++i;
        }
        return null;
    }

    public static DivineName getDivineName(ZodiacMansion lm) {
        int i = 0;
        while (i < DivineName.values().length) {
            if (DivineName.values()[i].lunarMansion == lm) {
                return DivineName.values()[i];
            }
            ++i;
        }
        return null;
    }

    public static DivineName getDivineName(Manifestation m) {
        int i = 0;
        while (i < DivineName.values().length) {
            if (DivineName.values()[i].manifestation == m) {
                return DivineName.values()[i];
            }
            ++i;
        }
        return null;
    }

    public static Element getElement(boolean isMoist, boolean isHot) {
        if (isMoist && isHot) {
            return Element.AIR;
        }
        if (isMoist && !isHot) {
            return Element.WATER;
        }
        if (!isMoist && isHot) {
            return Element.FIRE;
        }
        if (!isMoist && !isHot) {
            return Element.EARTH;
        }
        return null;
    }

    public static Element getElement(Temperament t) {
        return EsotericEssentials.getElement(t.isMoist(), t.isHot());
    }

    public static double[] getElementDistribution(String phrase) {
        return EsotericEssentials.getElementDistribution(EsotericEssentials.toWordArray(phrase));
    }

    public static double[] getElementDistribution(Word[] words) {
        int[] result = new int[4];
        int j = 0;
        while (j < words.length) {
            int n = EsotericEssentials.asZodiacSign((long)EsotericEssentials.asNumber((Word)words[j])).element.ordinal();
            result[n] = result[n] + 1;
            ++j;
        }
        return MathEssentials.toPercentage(result);
    }

    public static Letter getLetter(DivineName name) {
        int i = 0;
        while (i < DivineName.values().length) {
            if (DivineName.values()[i] == name) {
                return DivineName.values()[i].letter;
            }
            ++i;
        }
        return null;
    }

    public static ZodiacMansion getZodiacMansion(DivineName name) {
        int i = 0;
        while (i < DivineName.values().length) {
            if (DivineName.values()[i] == name) {
                return DivineName.values()[i].lunarMansion;
            }
            ++i;
        }
        return null;
    }

    public static ZodiacMansion getZodiacMansion(double degree) {
        degree = EsotericEssentials.normalizeZodiacDegree(degree);
        ZodiacMansion[] zodiacMansionArray = ZodiacMansion.values();
        int n = zodiacMansionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ZodiacMansion m = zodiacMansionArray[n2];
            if (m.degreeSpan.isInRange(degree)) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    public static ZodiacMansion getZodiacMansion(int order) {
        return ZodiacMansion.values()[order - 1];
    }

    public static ZodiacMansion getZodiacMansion(ZodiacDegree deg) {
        return EsotericEssentials.getZodiacMansion(deg.degree);
    }

    public static double[] getZodiacMansionDistribution(String phrase) {
        return EsotericEssentials.getZodiacMansionDistribution(EsotericEssentials.toWordArray(phrase));
    }

    public static double[] getZodiacMansionDistribution(Word[] words) {
        int[] result = new int[28];
        int j = 0;
        while (j < words.length) {
            int n = EsotericEssentials.asZodiacMansion(EsotericEssentials.asNumber(words[j])).ordinal();
            result[n] = result[n] + 1;
            ++j;
        }
        return MathEssentials.toPercentage(result);
    }

    public static Manifestation getManifestation(DivineName name) {
        int i = 0;
        while (i < DivineName.values().length) {
            if (DivineName.values()[i] == name) {
                return DivineName.values()[i].manifestation;
            }
            ++i;
        }
        return null;
    }

    public static Manifestation getManifestation(int degreeOfManifestation) {
        return Manifestation.values()[degreeOfManifestation - 1];
    }

    public static Planet getPlanet(String planetName, String lang) {
        int i = 0;
        while (i < Planet.values().length) {
            Planet p = Planet.values()[i];
            if (p.getName(lang).equals(planetName)) {
                return p;
            }
            ++i;
        }
        return null;
    }

    public static ZodiacSign getZodiacSign(double degree) {
        degree = EsotericEssentials.normalizeZodiacDegree(degree);
        ZodiacSign[] zodiacSignArray = ZodiacSign.values();
        int n = zodiacSignArray.length;
        int n2 = 0;
        while (n2 < n) {
            ZodiacSign zs = zodiacSignArray[n2];
            if (zs.degreeSpan.isInRange(degree)) {
                return zs;
            }
            ++n2;
        }
        return null;
    }

    public static ZodiacSign getZodiacSign(Element element, Modality modality) {
        CircularArray<ZodiacSign> zs = EsotericEssentials.getZodiacSignOrder();
        while (zs.current().element != element || zs.current().modality != modality) {
            zs.next();
        }
        return zs.current();
    }

    public static ZodiacSign getZodiacSign(ZodiacDegree deg) {
        return EsotericEssentials.getZodiacSign(deg.degree);
    }

    public static double[] getZodiacSignDistribution(String phrase) {
        return EsotericEssentials.getZodiacSignDistribution(EsotericEssentials.toWordArray(phrase));
    }

    public static double[] getZodiacSignDistribution(Word[] words) {
        int[] result = new int[12];
        int j = 0;
        while (j < words.length) {
            int n = EsotericEssentials.asZodiacSign(EsotericEssentials.asNumber(words[j])).ordinal();
            result[n] = result[n] + 1;
            ++j;
        }
        return MathEssentials.toPercentage(result);
    }

    public static final CircularArray<ZodiacSign> getZodiacSignOrder() {
        return new CircularArray<ZodiacSign>(ZodiacSign.values());
    }

    public static List<ZodiacSign> getZodiacSignSpan(ZodiacMansion m) {
        ArrayList<ZodiacSign> result = new ArrayList<ZodiacSign>();
        result.add(EsotericEssentials.getZodiacSign(m.degreeSpan.start));
        ZodiacSign tmp = EsotericEssentials.getZodiacSign(m.degreeSpan.end);
        if (!result.contains((Object)tmp)) {
            result.add(tmp);
        }
        return result;
    }

    public static boolean isTransitionalZodiacMansion(ZodiacMansion m) {
        return EsotericEssentials.getZodiacSignSpan(m).size() > 1;
    }

    public static Element marry(Element e1, Element e2) {
        if (e1 == Element.FIRE && e2 == Element.EARTH) {
            return Element.FIRE;
        }
        if (e1 == Element.FIRE && e2 == Element.AIR) {
            return Element.EARTH;
        }
        if (e1 == Element.FIRE && e2 == Element.WATER) {
            return Element.AIR;
        }
        if (e1 == Element.EARTH && e2 == Element.AIR) {
            return Element.AIR;
        }
        if (e1 == Element.EARTH && e2 == Element.WATER) {
            return Element.WATER;
        }
        if (e1 == Element.AIR && e2 == Element.WATER) {
            return Element.FIRE;
        }
        if (e1 == Element.AIR && e2 == Element.AIR) {
            return Element.WATER;
        }
        if (e1 == Element.WATER && e2 == Element.WATER) {
            return Element.EARTH;
        }
        if (e1 == Element.EARTH && e2 == Element.EARTH) {
            return Element.EARTH;
        }
        if (e1 == Element.FIRE && e2 == Element.FIRE) {
            return Element.WATER;
        }
        return EsotericEssentials.marry(e2, e1);
    }

    public static Gender marry(Gender g1, Gender g2) {
        if (g1 == Gender.MALE && g2 == Gender.FEMALE) {
            return Gender.MALE;
        }
        if (g1 == Gender.FEMALE && g2 == Gender.FEMALE) {
            return Gender.FEMALE;
        }
        if (g1 == Gender.MALE && g2 == Gender.MALE) {
            return Gender.FEMALE;
        }
        return EsotericEssentials.marry(g2, g1);
    }

    public static Modality marry(Modality m1, Modality m2) {
        if (m1 == Modality.CARDINAL && m2 == Modality.FIXED) {
            return Modality.MUTABLE;
        }
        if (m1 == Modality.CARDINAL && m2 == Modality.MUTABLE) {
            return Modality.CARDINAL;
        }
        if (m1 == Modality.FIXED && m2 == Modality.MUTABLE) {
            return Modality.FIXED;
        }
        if (m1 == Modality.MUTABLE && m2 == Modality.MUTABLE) {
            return Modality.MUTABLE;
        }
        if (m1 == Modality.CARDINAL && m2 == Modality.CARDINAL) {
            return Modality.FIXED;
        }
        if (m1 == Modality.FIXED && m2 == Modality.FIXED) {
            return Modality.CARDINAL;
        }
        return EsotericEssentials.marry(m2, m1);
    }

    public static ZodiacDegree marry(ZodiacDegree d1, ZodiacDegree d2) {
        return new ZodiacDegree(EsotericEssentials.marry(d1.zodiacSign, d2.zodiacSign), (d1.zodiacSignOffset + d2.zodiacSignOffset) % 30.0);
    }

    public static ZodiacSign marry(ZodiacSign z1, ZodiacSign z2) {
        return EsotericEssentials.getZodiacSign(EsotericEssentials.marry(z1.element, z2.element), EsotericEssentials.marry(z1.modality, z2.modality));
    }

    public static double normalizeZodiacDegree(double degree) {
        while (degree < 0.0) {
            degree += 360.0;
        }
        if (degree < 360.0) {
            return degree;
        }
        return degree % 360.0;
    }

    public static Word[] toWordArray(String phrase) {
        return EsotericEssentials.toWordArray(phrase.split(" "));
    }

    public static Word[] toWordArray(String[] words) {
        Word[] result = new Word[words.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new Word(words[i]);
            ++i;
        }
        return result;
    }

    public static ZodiacDegree asZodiacDegree(String[] words) {
        return EsotericEssentials.asZodiacDegree(EsotericEssentials.toWordArray(words));
    }

    public static ZodiacDegree asZodiacDegree(Word[] words) {
        ZodiacDegree result = EsotericEssentials.asZodiacDegree(EsotericEssentials.asNumber(words[0]));
        int i = 1;
        while (i < words.length) {
            result = EsotericEssentials.marry(result, EsotericEssentials.asZodiacDegree(EsotericEssentials.asNumber(words[i])));
            ++i;
        }
        return result;
    }

    public static ZodiacSign asZodiacSign(String[] words) {
        return EsotericEssentials.asZodiacDegree((String[])words).zodiacSign;
    }

    public static ZodiacSign asZodiacSign(Word[] words) {
        return EsotericEssentials.asZodiacDegree((Word[])words).zodiacSign;
    }
}

