/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.essentials;

import info.thereisonlywe.core.essentials.MathEssentials;
import info.thereisonlywe.core.essentials.StringEssentials;
import info.thereisonlywe.core.essentials.SystemEssentials;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class IOEssentials {
    public static final int FILE_UPDATE_POLICY_NEVER = 0;
    public static final int FILE_UPDATE_POLICY_IF_POSSIBLE = 1;
    public static final int FILE_UPDATE_POLICY_STRICT = 2;
    public static final int FILE_UPDATE_POLICY_FORCED = 3;
    public static final int NETWORK_TIMEOUT_SHORT = 1000;
    public static final int NETWORK_TIMEOUT_MEDIUM = 3000;
    public static final int NETWORK_TIMEOUT_LONG = 9000;
    private static long lastInternetValidation = 0L;
    private static boolean sigTermDownload = false;

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            if (closeable instanceof OutputStream) {
                ((OutputStream)closeable).flush();
            }
            closeable.close();
        }
        catch (IOException e) {
            SystemEssentials.Logger.log(Level.WARNING, e);
        }
    }

    public static boolean copy(File sourceFile, File destFile) {
        FileChannel destination;
        FileChannel source;
        block3: {
            source = null;
            destination = null;
            try {
                if (destFile.exists() || destFile.createNewFile()) break block3;
                return false;
            }
            catch (IOException e) {
                SystemEssentials.Logger.log(Level.WARNING, e);
                return false;
            }
        }
        source = new FileInputStream(sourceFile).getChannel();
        destination = new FileOutputStream(destFile).getChannel();
        destination.transferFrom(source, 0L, source.size());
        return true;
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static void deleteTempFiles(File dir) {
        String[] list;
        String[] stringArray = list = dir.list();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.endsWith(".temp")) {
                new File(dir.getPath(), element).delete();
            }
            ++n2;
        }
    }

    public static void interruptDownload() {
        sigTermDownload = true;
    }

    public static boolean download(File dest, URL source) {
        return IOEssentials.download(dest, source, false, false);
    }

    public static boolean download(File dest, URL source, boolean directTransfer, boolean setUserAgent) {
        FileOutputStream output;
        BufferedInputStream input;
        block22: {
            if (!IOEssentials.gotInternetConnection()) {
                return false;
            }
            if (dest.exists() && dest.isFile()) {
                dest.delete();
            }
            if (dest.getParentFile() != null) {
                dest.getParentFile().mkdirs();
            }
            if (directTransfer) {
                ReadableByteChannel rbc;
                FileOutputStream fos;
                block21: {
                    fos = null;
                    rbc = null;
                    try {
                        long len = IOEssentials.getLength(source);
                        if (len >= 1L) {
                            URLConnection con = source.openConnection();
                            if (setUserAgent) {
                                con.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
                            }
                            rbc = Channels.newChannel(con.getInputStream());
                            fos = new FileOutputStream(dest);
                            fos.getChannel().transferFrom(rbc, 0L, len <= 0L ? Integer.MAX_VALUE : len);
                            break block21;
                        }
                        IOEssentials.closeQuietly(rbc);
                    }
                    catch (IOException e) {
                        SystemEssentials.Logger.log(Level.WARNING, e);
                        return false;
                    }
                    finally {
                        IOEssentials.closeQuietly(rbc);
                        IOEssentials.closeQuietly(fos);
                    }
                    IOEssentials.closeQuietly(fos);
                    return false;
                }
                IOEssentials.closeQuietly(rbc);
                IOEssentials.closeQuietly(fos);
                if (sigTermDownload || IOEssentials.readString(dest) == null || IOEssentials.readString(dest).contains("302 Found")) {
                    dest.delete();
                    return false;
                }
                return true;
            }
            input = null;
            output = null;
            URLConnection connection = null;
            FileLock lock = null;
            try {
                int count;
                connection = source.openConnection();
                if (setUserAgent) {
                    connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
                }
                connection.connect();
                input = new BufferedInputStream(connection.getInputStream());
                output = new FileOutputStream(dest);
                lock = output.getChannel().lock(0L, Long.MAX_VALUE, false);
                byte[] data = new byte[32768];
                long writeCount = 0L;
                while ((count = ((InputStream)input).read(data)) != -1 && !sigTermDownload) {
                    writeCount += (long)count;
                    output.write(data, 0, count);
                }
                if (lock != null) {
                    lock.release();
                }
                if (writeCount > 0L) break block22;
                IOEssentials.closeQuietly(output);
            }
            catch (Exception e) {
                SystemEssentials.Logger.log(Level.WARNING, e);
                return false;
            }
            finally {
                IOEssentials.closeQuietly(output);
                IOEssentials.closeQuietly(input);
            }
            IOEssentials.closeQuietly(input);
            return false;
        }
        IOEssentials.closeQuietly(output);
        IOEssentials.closeQuietly(input);
        if (sigTermDownload || IOEssentials.readString(dest) == null || IOEssentials.readString(dest).contains("302 Found")) {
            sigTermDownload = false;
            dest.delete();
            return false;
        }
        return true;
    }

    public static boolean exists(URL url, int timeout) {
        HttpURLConnection urlc = null;
        BufferedInputStream in = null;
        try {
            block11: {
                block10: {
                    urlc = (HttpURLConnection)url.openConnection();
                    urlc.setRequestProperty("User-Agent", "Test");
                    urlc.setRequestProperty("Connection", "close");
                    urlc.setReadTimeout(timeout);
                    urlc.setConnectTimeout(timeout);
                    urlc.connect();
                    if (urlc.getResponseCode() != 200) break block10;
                    in = new BufferedInputStream(urlc.getInputStream());
                    if (url.getHost().equals(urlc.getURL().getHost())) break block11;
                }
                return false;
            }
            IOEssentials.closeQuietly(in);
            if (urlc != null) {
                urlc.disconnect();
            }
            return true;
        }
        catch (Exception e) {
            SystemEssentials.Logger.log(Level.WARNING, e);
            return false;
        }
        finally {
            IOEssentials.closeQuietly(in);
            if (urlc != null) {
                urlc.disconnect();
            }
        }
    }

    public static boolean isWalledGardenConnection(int timeout) {
        HttpURLConnection urlConnection = null;
        try {
            URL url = new URL("http://clients3.google.com/generate_204");
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setInstanceFollowRedirects(false);
            urlConnection.setConnectTimeout(timeout);
            urlConnection.setReadTimeout(timeout);
            urlConnection.setUseCaches(false);
            urlConnection.getInputStream();
            boolean bl = urlConnection.getResponseCode() != 204;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public void zip(File[] srcFiles, File destFile) {
        block7: {
            BufferedInputStream origin = null;
            FileOutputStream dest = null;
            ZipOutputStream out = null;
            FileInputStream fi = null;
            try {
                try {
                    dest = new FileOutputStream(destFile);
                    out = new ZipOutputStream(new BufferedOutputStream(dest));
                    byte[] data = new byte[8196];
                    int i = 0;
                    while (i < srcFiles.length) {
                        int count;
                        fi = new FileInputStream(srcFiles[i]);
                        origin = new BufferedInputStream(fi, 8196);
                        ZipEntry entry = new ZipEntry(srcFiles[i].getName());
                        out.putNextEntry(entry);
                        while ((count = origin.read(data, 0, 8196)) != -1) {
                            out.write(data, 0, count);
                        }
                        origin.close();
                        ++i;
                    }
                    out.close();
                }
                catch (Exception e) {
                    SystemEssentials.Logger.log(Level.WARNING, e);
                    IOEssentials.closeQuietly(origin);
                    IOEssentials.closeQuietly(fi);
                    IOEssentials.closeQuietly(out);
                    IOEssentials.closeQuietly(dest);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                IOEssentials.closeQuietly(origin);
                IOEssentials.closeQuietly(fi);
                IOEssentials.closeQuietly(out);
                IOEssentials.closeQuietly(dest);
                throw throwable;
            }
            IOEssentials.closeQuietly(origin);
            IOEssentials.closeQuietly(fi);
            IOEssentials.closeQuietly(out);
            IOEssentials.closeQuietly(dest);
        }
    }

    public static void unzip(String srcFile, String destFolder) {
        block8: {
            FileInputStream inStream = null;
            ZipInputStream zipStream = null;
            BufferedOutputStream bufferOut = null;
            FileOutputStream outStream = null;
            try {
                try {
                    ZipEntry entry;
                    inStream = new FileInputStream(srcFile);
                    zipStream = new ZipInputStream(new BufferedInputStream(inStream));
                    new File(destFolder).mkdirs();
                    while ((entry = zipStream.getNextEntry()) != null) {
                        int size;
                        if (entry.isDirectory()) {
                            new File(String.valueOf(destFolder) + entry.getName()).mkdirs();
                            continue;
                        }
                        byte[] buffer = new byte[8196];
                        outStream = new FileOutputStream(String.valueOf(destFolder) + entry.getName());
                        bufferOut = new BufferedOutputStream(outStream, buffer.length);
                        while ((size = zipStream.read(buffer, 0, buffer.length)) != -1) {
                            bufferOut.write(buffer, 0, size);
                        }
                    }
                }
                catch (Exception e) {
                    SystemEssentials.Logger.log(Level.WARNING, e);
                    IOEssentials.closeQuietly(bufferOut);
                    IOEssentials.closeQuietly(outStream);
                    IOEssentials.closeQuietly(zipStream);
                    IOEssentials.closeQuietly(inStream);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                IOEssentials.closeQuietly(bufferOut);
                IOEssentials.closeQuietly(outStream);
                IOEssentials.closeQuietly(zipStream);
                IOEssentials.closeQuietly(inStream);
                throw throwable;
            }
            IOEssentials.closeQuietly(bufferOut);
            IOEssentials.closeQuietly(outStream);
            IOEssentials.closeQuietly(zipStream);
            IOEssentials.closeQuietly(inStream);
        }
    }

    public static String fetchLine(Class<?> c, String path, int lineNo) {
        return IOEssentials.fetchLine(c.getClassLoader(), path.charAt(0) != '/' ? path : new String(path.substring(1, path.length())), lineNo);
    }

    public static String fetchLine(ClassLoader c, String path, int lineNo) {
        try {
            String strLine;
            InputStream fstream = c.getResourceAsStream(path);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
            int counter = 1;
            while ((strLine = br.readLine()) != null) {
                if (counter == lineNo) {
                    br.close();
                    return strLine;
                }
                ++counter;
            }
            br.close();
        }
        catch (IOException e) {
            SystemEssentials.Logger.log(Level.WARNING, e);
        }
        return null;
    }

    public static String fetchValue(File file, String labelAndSeparator) {
        FileInputStream fstream = null;
        DataInputStream in = null;
        BufferedReader br = null;
        String strLine = null;
        try {
            try {
                fstream = new FileInputStream(file);
                in = new DataInputStream(fstream);
                br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                while ((strLine = br.readLine()) != null) {
                    if (strLine.trim().startsWith(labelAndSeparator)) break;
                }
                br.close();
            }
            catch (IOException e) {
                SystemEssentials.Logger.log(Level.WARNING, e);
                IOEssentials.closeQuietly(br);
                IOEssentials.closeQuietly(in);
                IOEssentials.closeQuietly(fstream);
                return null;
            }
        }
        catch (Throwable throwable) {
            IOEssentials.closeQuietly(br);
            IOEssentials.closeQuietly(in);
            IOEssentials.closeQuietly(fstream);
            throw throwable;
        }
        IOEssentials.closeQuietly(br);
        IOEssentials.closeQuietly(in);
        IOEssentials.closeQuietly(fstream);
        if (strLine == null) {
            return "";
        }
        String[] tmp = strLine.split(labelAndSeparator);
        if (tmp.length > 1) {
            return strLine.split(labelAndSeparator)[1];
        }
        return "";
    }

    public static String fetchLine(File file, int lineNo) {
        FileInputStream fstream = null;
        DataInputStream in = null;
        BufferedReader br = null;
        String strLine = null;
        try {
            try {
                fstream = new FileInputStream(file);
                in = new DataInputStream(fstream);
                br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                int counter = 1;
                while ((strLine = br.readLine()) != null) {
                    if (counter == lineNo) break;
                    ++counter;
                }
                br.close();
            }
            catch (IOException e) {
                SystemEssentials.Logger.log(Level.WARNING, e);
                IOEssentials.closeQuietly(br);
                IOEssentials.closeQuietly(in);
                IOEssentials.closeQuietly(fstream);
                return null;
            }
        }
        catch (Throwable throwable) {
            IOEssentials.closeQuietly(br);
            IOEssentials.closeQuietly(in);
            IOEssentials.closeQuietly(fstream);
            throw throwable;
        }
        IOEssentials.closeQuietly(br);
        IOEssentials.closeQuietly(in);
        IOEssentials.closeQuietly(fstream);
        return strLine;
    }

    public static long getLastModified(URL u) {
        long size = 0L;
        try {
            URLConnection conn = u.openConnection();
            size = conn.getLastModified();
            return size;
        }
        catch (IOException e) {
            SystemEssentials.Logger.log(Level.WARNING, e);
            return -1L;
        }
    }

    public static long getLength(URL u) {
        int size = 0;
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)u.openConnection();
            conn.setRequestProperty("User-Agent", "Test");
            conn.setRequestProperty("Connection", "close");
            conn.getInputStream();
            size = conn.getContentLength();
            long l = size;
            return l;
        }
        catch (IOException e) {
            SystemEssentials.Logger.log(Level.WARNING, e);
            return -1L;
        }
        finally {
            conn.disconnect();
        }
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static int getLineCount(File file) {
        int n;
        LineNumberReader lnr = null;
        try {
            lnr = new LineNumberReader(new FileReader(file));
            lnr.skip(Long.MAX_VALUE);
            n = lnr.getLineNumber() + 1;
        }
        catch (FileNotFoundException e) {
            SystemEssentials.Logger.log(Level.WARNING, e);
            IOEssentials.closeQuietly(lnr);
        }
        catch (IOException e2) {
            SystemEssentials.Logger.log(Level.WARNING, e2);
            {
                catch (Throwable throwable) {
                    IOEssentials.closeQuietly(lnr);
                    throw throwable;
                }
            }
            IOEssentials.closeQuietly(lnr);
        }
        IOEssentials.closeQuietly(lnr);
        return n;
        return -1;
    }

    public static File getRandomTempFile() {
        return IOEssentials.getRandomTempFile(null);
    }

    public static File getRandomTempFile(String parent) {
        File f = new File(parent, String.valueOf(MathEssentials.newRandom()) + ".temp");
        while (f.exists()) {
            f = IOEssentials.getRandomTempFile();
        }
        f.deleteOnExit();
        return f;
    }

    public static String getRunningClassPath(Class<?> c) {
        String res = c.getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            res = URLDecoder.decode(res, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return res;
    }

    public static boolean gotInternetConnection() {
        return IOEssentials.gotInternetConnection(1000, 333);
    }

    public static boolean gotInternetConnection(int timeout, int allowedMillisAfterLastCheck) {
        if (System.currentTimeMillis() - lastInternetValidation <= (long)allowedMillisAfterLastCheck) {
            return true;
        }
        HttpURLConnection urlConnection = null;
        try {
            URL url = new URL("http://clients3.google.com/generate_204");
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setInstanceFollowRedirects(false);
            urlConnection.setConnectTimeout(timeout);
            urlConnection.setReadTimeout(timeout);
            urlConnection.setUseCaches(false);
            urlConnection.getInputStream();
            if (urlConnection.getResponseCode() == 204) {
                lastInternetValidation = System.currentTimeMillis();
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return false;
    }

    public static boolean isSymlink(File file) throws IOException {
        File canon;
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        if (file.getParent() == null) {
            canon = file;
        } else {
            File canonDir = file.getParentFile().getCanonicalFile();
            canon = new File(canonDir, file.getName());
        }
        return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
    }

    public static byte[] readBytes(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            ((InputStream)is).close();
            return null;
        }
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            SystemEssentials.Logger.log(Level.WARNING, new IOException("Could not completely read file"));
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static String readString(InputStream inputStream) {
        return IOEssentials.readString(inputStream, "UTF-8");
    }

    /*
     * Loose catch block
     */
    public static String readString(InputStream inputStream, String encoding) {
        if (inputStream != null) {
            StringWriter writer;
            block8: {
                writer = new StringWriter();
                BufferedReader reader = null;
                char[] buffer = new char[32768];
                try {
                    int n;
                    reader = new BufferedReader(new InputStreamReader(inputStream, encoding), 32768);
                    while ((n = reader.read(buffer)) != -1) {
                        ((Writer)writer).write(buffer, 0, n);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    IOEssentials.closeQuietly(reader);
                    IOEssentials.closeQuietly(writer);
                    IOEssentials.closeQuietly(inputStream);
                    break block8;
                }
                catch (IOException iOException) {
                    IOEssentials.closeQuietly(reader);
                    IOEssentials.closeQuietly(writer);
                    IOEssentials.closeQuietly(inputStream);
                    break block8;
                    catch (Throwable throwable) {
                        IOEssentials.closeQuietly(reader);
                        IOEssentials.closeQuietly(writer);
                        IOEssentials.closeQuietly(inputStream);
                        throw throwable;
                    }
                }
                IOEssentials.closeQuietly(reader);
                IOEssentials.closeQuietly(writer);
                IOEssentials.closeQuietly(inputStream);
            }
            return ((Object)writer).toString();
        }
        return null;
    }

    public static String readString(Class<?> c, String path) {
        return IOEssentials.readString(c.getClassLoader(), path.charAt(0) != '/' ? path : new String(path.substring(1, path.length())), "UTF-8");
    }

    public static String readString(Class<?> c, String path, String encoding) {
        return IOEssentials.readString(c.getClassLoader(), path.charAt(0) != '/' ? path : new String(path.substring(1, path.length())), encoding);
    }

    public static String readString(ClassLoader c, String path) {
        return IOEssentials.readString(c, path, "UTF-8");
    }

    public static String readString(ClassLoader c, String path, String encoding) {
        StringBuilder result;
        block8: {
            InputStream fstream = null;
            DataInputStream in = null;
            BufferedReader br = null;
            result = new StringBuilder();
            boolean first = true;
            try {
                try {
                    String strLine;
                    fstream = c.getResourceAsStream(path);
                    in = new DataInputStream(fstream);
                    br = new BufferedReader(new InputStreamReader((InputStream)in, encoding));
                    while ((strLine = br.readLine()) != null) {
                        if (!first) {
                            strLine = "\n" + strLine;
                        } else {
                            first = false;
                        }
                        result.append(strLine);
                    }
                }
                catch (IOException e) {
                    SystemEssentials.Logger.log(Level.WARNING, e);
                    IOEssentials.closeQuietly(br);
                    IOEssentials.closeQuietly(in);
                    IOEssentials.closeQuietly(fstream);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                IOEssentials.closeQuietly(br);
                IOEssentials.closeQuietly(in);
                IOEssentials.closeQuietly(fstream);
                throw throwable;
            }
            IOEssentials.closeQuietly(br);
            IOEssentials.closeQuietly(in);
            IOEssentials.closeQuietly(fstream);
        }
        return result.toString();
    }

    public static String readString(File file) {
        return IOEssentials.readStringUntilLine(file, Long.MAX_VALUE, "UTF-8");
    }

    public static String readString(File file, String encoding) {
        return IOEssentials.readStringUntilLine(file, Long.MAX_VALUE, encoding);
    }

    public static String[] readStrings(File file) {
        return StringEssentials.splitLines(IOEssentials.readString(file));
    }

    public static String[] readStrings(InputStream inputStream) {
        return StringEssentials.splitLines(IOEssentials.readString(inputStream));
    }

    public static String readStringUntilLine(Class<?> c, String path, int line) {
        return IOEssentials.readStringUntilLine(c.getClassLoader(), path.charAt(0) != '/' ? path : new String(path.substring(1, path.length())), line);
    }

    public static String readStringUntilLine(ClassLoader c, String path, int line) {
        StringBuilder result;
        block9: {
            InputStream fstream = null;
            DataInputStream in = null;
            BufferedReader br = null;
            result = new StringBuilder();
            boolean first = true;
            int counter = 1;
            try {
                try {
                    String strLine;
                    fstream = c.getResourceAsStream(path);
                    in = new DataInputStream(fstream);
                    br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                    while ((strLine = br.readLine()) != null) {
                        if (counter != line) {
                            ++counter;
                            if (!first) {
                                strLine = "\n" + strLine;
                            } else {
                                first = false;
                            }
                            result.append(strLine);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    SystemEssentials.Logger.log(Level.WARNING, e);
                    IOEssentials.closeQuietly(br);
                    IOEssentials.closeQuietly(in);
                    IOEssentials.closeQuietly(fstream);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                IOEssentials.closeQuietly(br);
                IOEssentials.closeQuietly(in);
                IOEssentials.closeQuietly(fstream);
                throw throwable;
            }
            IOEssentials.closeQuietly(br);
            IOEssentials.closeQuietly(in);
            IOEssentials.closeQuietly(fstream);
        }
        return result.toString();
    }

    public static String readStringUntilLine(File file, long line, String encoding) {
        StringBuilder result;
        block10: {
            if (!file.exists()) {
                return null;
            }
            FileInputStream fstream = null;
            DataInputStream in = null;
            BufferedReader br = null;
            result = new StringBuilder();
            long counter = 1L;
            try {
                try {
                    String strLine;
                    fstream = new FileInputStream(file);
                    in = new DataInputStream(fstream);
                    br = new BufferedReader(new InputStreamReader((InputStream)in, encoding));
                    boolean first = true;
                    while ((strLine = br.readLine()) != null) {
                        if (counter != line) {
                            ++counter;
                            if (!first) {
                                strLine = "\n" + strLine;
                            } else {
                                first = false;
                            }
                            result.append(strLine);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    SystemEssentials.Logger.log(Level.WARNING, e);
                    IOEssentials.closeQuietly(br);
                    IOEssentials.closeQuietly(in);
                    IOEssentials.closeQuietly(fstream);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                IOEssentials.closeQuietly(br);
                IOEssentials.closeQuietly(in);
                IOEssentials.closeQuietly(fstream);
                throw throwable;
            }
            IOEssentials.closeQuietly(br);
            IOEssentials.closeQuietly(in);
            IOEssentials.closeQuietly(fstream);
        }
        return result.toString();
    }

    public static void removeBlankLines(File f) {
        ArrayList<String> res = new ArrayList<String>();
        String[] lines = IOEssentials.readStrings(f);
        int i = 0;
        while (i < lines.length) {
            if (!lines[i].trim().equals("")) {
                res.add(lines[i]);
            }
            ++i;
        }
        IOEssentials.write(StringEssentials.glue(res, "\n"), f);
    }

    public static boolean removeDuplicateLines(File f) {
        return IOEssentials.write(StringEssentials.glue(StringEssentials.removeDuplicates(IOEssentials.readStrings(f)), "\n"), f, false);
    }

    public static void removeFolder(File dir) {
        String[] val = dir.list();
        if (val != null) {
            String[] stringArray = val;
            int n = val.length;
            int n2 = 0;
            while (n2 < n) {
                File f;
                String element = stringArray[n2];
                File file = f = dir.getParent() != null ? new File(String.valueOf(dir.getParent()) + File.separator + dir.getName() + File.separator + element) : new File(String.valueOf(dir.getName()) + File.separator + element);
                if (f.isFile()) {
                    f.delete();
                } else {
                    IOEssentials.removeFolder(f);
                }
                ++n2;
            }
        }
        dir.delete();
    }

    public static void removeLines(File f, int[] lines) {
        ArrayList<String> entries = new ArrayList<String>();
        String[] ln = StringEssentials.splitLines(IOEssentials.readString(f));
        int i = 0;
        while (i < ln.length) {
            block3: {
                int j = 0;
                while (j < lines.length) {
                    if (i + 1 != lines[j]) {
                        ++j;
                        continue;
                    }
                    break block3;
                }
                entries.add(ln[i]);
            }
            ++i;
        }
        ln = null;
        IOEssentials.write(StringEssentials.glue(entries, "\n"), f, false);
    }

    public static URL toURL(String path) {
        URL res = null;
        try {
            res = new URL(path);
        }
        catch (MalformedURLException ex) {
            SystemEssentials.Logger.log(Level.WARNING, ex);
        }
        return res;
    }

    public static void updateInBackground(final File file, final URL url) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                IOEssentials.update(file, url);
            }
        }).start();
    }

    public static boolean update(File file, URL url) {
        return IOEssentials.update(file, url, 1);
    }

    public static boolean update(File file, URL url, int updatePolicy) {
        SystemEssentials.Logger.log(Level.INFO, "Updating " + file + "...");
        if (updatePolicy == 0 && file.exists()) {
            return true;
        }
        if (!IOEssentials.gotInternetConnection()) {
            return file.exists() && updatePolicy != 3;
        }
        switch (updatePolicy) {
            case 0: {
                if (!file.exists()) {
                    if (url == null) {
                        return false;
                    }
                    return IOEssentials.download(file, url);
                }
                return true;
            }
            case 1: {
                if (!file.exists()) {
                    if (url == null) {
                        return false;
                    }
                    return IOEssentials.download(file, url);
                }
                if (url == null) {
                    return true;
                }
                long size = IOEssentials.getLength(url);
                if (size != file.length() && size >= 1L) {
                    if (file.delete()) {
                        return IOEssentials.download(file, url);
                    }
                    File temp = IOEssentials.getRandomTempFile(file.getParent());
                    if (IOEssentials.download(temp, url)) {
                        boolean v = IOEssentials.copy(temp, file);
                        temp.deleteOnExit();
                        return v && file.exists();
                    }
                    temp.deleteOnExit();
                    return true;
                }
                return true;
            }
            case 2: {
                long l_;
                if (!file.exists()) {
                    if (url == null) {
                        return false;
                    }
                    return IOEssentials.download(file, url);
                }
                if (url == null) {
                    return true;
                }
                long size = IOEssentials.getLength(url);
                if (size != (l_ = file.length())) {
                    File temp = IOEssentials.getRandomTempFile(file.getParent());
                    boolean val = IOEssentials.download(temp, url);
                    if (val) {
                        boolean v = IOEssentials.copy(temp, file);
                        temp.delete();
                        return v;
                    }
                    temp.delete();
                    return file.exists() && file.length() == l_;
                }
                return true;
            }
            case 3: {
                if (!file.exists()) {
                    if (url == null) {
                        return false;
                    }
                    return IOEssentials.download(file, url);
                }
                if (url == null) {
                    return false;
                }
                long size = IOEssentials.getLength(url);
                if (size != file.length()) {
                    File temp = IOEssentials.getRandomTempFile(file.getParent());
                    boolean val = IOEssentials.download(temp, url);
                    if (val) {
                        boolean v = IOEssentials.copy(temp, file);
                        temp.delete();
                        return v;
                    }
                    temp.delete();
                    return val;
                }
                return size != -1L;
            }
        }
        return IOEssentials.update(file, url, 1);
    }

    public static boolean write(byte[] array, File file, boolean append) {
        boolean success;
        block6: {
            success = true;
            FileOutputStream fos = null;
            BufferedOutputStream bos = null;
            if (file.getParentFile().mkdirs()) {
                try {
                    try {
                        fos = new FileOutputStream(file, append);
                        bos = new BufferedOutputStream(fos, 65536);
                        bos.write(array);
                        bos.flush();
                    }
                    catch (IOException e) {
                        SystemEssentials.Logger.log(Level.WARNING, e);
                        success = false;
                        IOEssentials.closeQuietly(bos);
                        IOEssentials.closeQuietly(fos);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    IOEssentials.closeQuietly(bos);
                    IOEssentials.closeQuietly(fos);
                    throw throwable;
                }
                IOEssentials.closeQuietly(bos);
                IOEssentials.closeQuietly(fos);
            }
        }
        return success;
    }

    public static boolean write(char[] text, File file, boolean append) {
        boolean success;
        block5: {
            success = true;
            FileOutputStream fstream = null;
            DataOutputStream out = null;
            BufferedWriter FW = null;
            try {
                try {
                    file.getParentFile().mkdirs();
                    fstream = new FileOutputStream(file, append);
                    out = new DataOutputStream(fstream);
                    FW = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
                    FW.write(text);
                }
                catch (IOException e) {
                    SystemEssentials.Logger.log(Level.WARNING, e);
                    success = false;
                    IOEssentials.closeQuietly(FW);
                    IOEssentials.closeQuietly(out);
                    IOEssentials.closeQuietly(fstream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOEssentials.closeQuietly(FW);
                IOEssentials.closeQuietly(out);
                IOEssentials.closeQuietly(fstream);
                throw throwable;
            }
            IOEssentials.closeQuietly(FW);
            IOEssentials.closeQuietly(out);
            IOEssentials.closeQuietly(fstream);
        }
        return success;
    }

    public static boolean write(String data, File file) {
        return IOEssentials.write(data, file, false);
    }

    public static boolean write(String data, File file, boolean append) {
        boolean success;
        block6: {
            success = true;
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream fstream = null;
            DataOutputStream out = null;
            BufferedWriter FW = null;
            try {
                try {
                    fstream = new FileOutputStream(file, append);
                    out = new DataOutputStream(fstream);
                    FW = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
                    FW.write(data);
                }
                catch (IOException e) {
                    SystemEssentials.Logger.log(Level.WARNING, e);
                    success = false;
                    IOEssentials.closeQuietly(FW);
                    IOEssentials.closeQuietly(out);
                    IOEssentials.closeQuietly(fstream);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOEssentials.closeQuietly(FW);
                IOEssentials.closeQuietly(out);
                IOEssentials.closeQuietly(fstream);
                throw throwable;
            }
            IOEssentials.closeQuietly(FW);
            IOEssentials.closeQuietly(out);
            IOEssentials.closeQuietly(fstream);
        }
        return success;
    }

    public static class FileExtensionFilter
    implements FilenameFilter {
        private final String ext;

        public FileExtensionFilter(String ext) {
            this.ext = ("." + ext).toLowerCase();
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(this.ext);
        }
    }
}

