/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.essentials;

import info.thereisonlywe.core.essentials.DataEssentials;
import info.thereisonlywe.core.essentials.StringEssentials;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class MathEssentials {
    public static int sumDigits(int n) {
        return n - 9 * ((n - 1) / 9);
    }

    public static int add(int ... values) {
        long sum = 0L;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            if ((sum += (long)value) > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (sum < Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            ++n2;
        }
        return (int)sum;
    }

    public static int subtract(int from, int amount) {
        long sum = 0L;
        sum = from - amount;
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (sum < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)sum;
    }

    public static long add(long left, long right) {
        if (MathEssentials.adds(left, right)) {
            return left + right;
        }
        return Long.MAX_VALUE;
    }

    public static long subtract(long left, long right) {
        if (MathEssentials.subtracts(left, right)) {
            return left - right;
        }
        return Long.MIN_VALUE;
    }

    public static boolean adds(long left, long right) {
        if (right < 0L && right != Long.MIN_VALUE) {
            return MathEssentials.subtracts(left, -right);
        }
        return ((left ^ right ^ 0xFFFFFFFFFFFFFFFFL) & (left ^ left + right)) < 0L;
    }

    public static boolean subtracts(long left, long right) {
        if (right < 0L) {
            return MathEssentials.adds(left, -right);
        }
        return ((left ^ right) & (left ^ left - right)) < 0L;
    }

    public static boolean adds(int left, int right) {
        if (right < 0 && (long)right != Long.MIN_VALUE) {
            return MathEssentials.subtracts(left, -right);
        }
        return (~(left ^ right) & (left ^ left + right)) < 0;
    }

    public static boolean subtracts(int left, int right) {
        if (right < 0) {
            return MathEssentials.adds(left, -right);
        }
        return ((left ^ right) & (left ^ left - right)) < 0;
    }

    public static ArrayList<Integer> changeNumberBase(int sourceNumberBase, int targetNumberBase, int[] sourceDigits) {
        return MathEssentials.toNumberBase(targetNumberBase, MathEssentials.fromNumberBase(sourceNumberBase, sourceDigits));
    }

    public static String changeNumberBase(int sourceNumberBase, int targetNumberBase, int[] sourceDigits, char separator) {
        return MathEssentials.toNumberBase(targetNumberBase, MathEssentials.fromNumberBase(sourceNumberBase, sourceDigits), separator);
    }

    public static String changeNumberBase(int sourceNumberBase, int targetNumberBase, String sourceDigits, char separator) {
        return MathEssentials.toNumberBase(targetNumberBase, MathEssentials.fromNumberBase(sourceNumberBase, sourceDigits, separator), separator);
    }

    public static long changeNumberBase_PreDecimal(int sourceNumberBase, int targetNumberBase, long number) {
        return MathEssentials.toNumberBase_PreDecimal(targetNumberBase, MathEssentials.fromNumberBase_PreDecimal(sourceNumberBase, number));
    }

    public static long changeNumberBase_ToPreDecimal(int sourceNumberBase, int targetNumberBase, String sourceDigits, char separator) {
        return MathEssentials.toNumberBase_PreDecimal(targetNumberBase, MathEssentials.fromNumberBase(sourceNumberBase, sourceDigits, separator));
    }

    public static String changeNumberBase_FromPreDecimal(int sourceNumberBase, int targetNumberBase, long number, char separator) {
        return MathEssentials.toNumberBase(targetNumberBase, MathEssentials.fromNumberBase_PreDecimal(sourceNumberBase, number), separator);
    }

    public static double degreesToRadians(double deg) {
        return deg * Math.PI / 180.0;
    }

    public static double radiansToDegrees(double rad) {
        return rad * 180.0 / Math.PI;
    }

    public static long fromNumberBase(int sourceNumberBase, int[] digits) {
        long result = 0L;
        long l = 1L;
        int i = digits.length - 1;
        while (i >= 0) {
            if (i < digits.length - 1) {
                l *= (long)sourceNumberBase;
            }
            result += l * (long)digits[i];
            --i;
        }
        return result;
    }

    public static long fromNumberBase(int sourceNumberBase, String numberDigits, char separator) {
        return MathEssentials.fromNumberBase(sourceNumberBase, DataEssentials.toIntArray(numberDigits.split(String.valueOf(separator))));
    }

    public static long fromNumberBase_PreDecimal(int sourceNumberBase, long number) {
        if (sourceNumberBase > 10) {
            throw new InvalidParameterException("Number base cannot exceed 10.");
        }
        return MathEssentials.fromNumberBase(sourceNumberBase, DataEssentials.toIntArray(number));
    }

    public static int getClosestToRadix(int[] values, int radix) {
        int previndex = 0;
        int bestValue = Integer.MAX_VALUE;
        int i = 0;
        while (i < values.length) {
            int tmp = Math.abs(MathEssentials.subtract(radix, values[i]));
            if (tmp < bestValue) {
                previndex = i;
                bestValue = tmp;
            }
            ++i;
        }
        return previndex;
    }

    public static int getClosestValueToRadix(int[] values, int radix) {
        return values[MathEssentials.getClosestToRadix(values, radix)];
    }

    public static double getDistance(double lat1, double lon1, double lat2, double lon2) {
        double theta = lon1 - lon2;
        double dist = Math.sin(MathEssentials.degreesToRadians(lat1)) * Math.sin(MathEssentials.degreesToRadians(lat2)) + Math.cos(MathEssentials.degreesToRadians(lat1)) * Math.cos(MathEssentials.degreesToRadians(lat2)) * Math.cos(MathEssentials.degreesToRadians(theta));
        dist = Math.acos(dist);
        dist = MathEssentials.radiansToDegrees(dist);
        dist = dist * 60.0 * 1.1515;
        return dist *= 1.609344;
    }

    public static int getMaxIndex(int[] values) {
        return MathEssentials.getClosestToRadix(values, Integer.MAX_VALUE);
    }

    public static int getMaxValue(int[] values) {
        return values[MathEssentials.getMaxIndex(values)];
    }

    public static int getMinIndex(int[] values) {
        return MathEssentials.getClosestToRadix(values, Integer.MIN_VALUE);
    }

    public static int getMinValue(int[] values) {
        return values[MathEssentials.getMinIndex(values)];
    }

    public static boolean nearlyEqual(double a, double b, double errorMargin) {
        double absA = Math.abs(a);
        double absB = Math.abs(b);
        double diff = Math.abs(a - b);
        if (a == b) {
            return true;
        }
        if (a == 0.0 || b == 0.0 || diff < Double.MIN_NORMAL) {
            return diff < errorMargin * Double.MIN_NORMAL;
        }
        return diff / (absA + absB) < errorMargin;
    }

    public static int newRandom() {
        Random r = new Random();
        int randint = r.nextInt(Integer.MAX_VALUE);
        return randint;
    }

    public static int newRandom(int lastValueAllowed) {
        Random r = new Random();
        int randint = r.nextInt(lastValueAllowed + 1);
        return randint;
    }

    /*
     * Unable to fully structure code
     */
    public static double reduce(double number, double reductionInterval, double criticalValue) {
        if (number < 0.0) {
            number *= -1.0;
        }
        if (reductionInterval != criticalValue) ** GOTO lbl6
        return number % criticalValue;
lbl-1000:
        // 1 sources

        {
            number -= reductionInterval;
lbl6:
            // 2 sources

            ** while (number >= criticalValue)
        }
lbl7:
        // 1 sources

        return number;
    }

    /*
     * Unable to fully structure code
     */
    public static long reduce(long number, long reductionInterval, long criticalValue) {
        if (number < 0L) {
            number *= -1L;
        }
        if (reductionInterval != criticalValue) ** GOTO lbl6
        return number % criticalValue;
lbl-1000:
        // 1 sources

        {
            number -= reductionInterval;
lbl6:
            // 2 sources

            ** while (number >= criticalValue)
        }
lbl7:
        // 1 sources

        return number;
    }

    /*
     * Unable to fully structure code
     */
    public static int reduce(int number, int reductionInterval, int criticalValue) {
        if (number < 0) {
            number *= -1;
        }
        if (reductionInterval != criticalValue) ** GOTO lbl6
        return number % criticalValue;
lbl-1000:
        // 1 sources

        {
            number -= reductionInterval;
lbl6:
            // 2 sources

            ** while (number >= criticalValue)
        }
lbl7:
        // 1 sources

        return number;
    }

    public static ArrayList<Integer> toNumberBase(int base, long number) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (number >= (long)base) {
            int remainder = (int)(number % (long)base);
            result.add(remainder);
            number /= (long)base;
        }
        result.add((int)number);
        Collections.reverse(result);
        return result;
    }

    public static String toNumberBase(int base, long number, char separator) {
        return StringEssentials.glue(DataEssentials.toStringArrayList(MathEssentials.toNumberBase(28, 111L)), separator);
    }

    public static long toNumberBase_PreDecimal(int base, long number) {
        if (base > 10) {
            throw new InvalidParameterException("Number base cannot exceed 10.");
        }
        return Long.parseLong(StringEssentials.glue(DataEssentials.toStringArrayList(MathEssentials.toNumberBase(base, number)), ""));
    }

    public static double[] toPercentage(double[] values) {
        double counter = 0.0;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double t = dArray[n2];
            counter += t;
            ++n2;
        }
        int i = 0;
        while (i < values.length) {
            values[i] = Math.round(values[i] * 100.0 / counter);
            ++i;
        }
        return values;
    }

    public static double[] toPercentage(int[] values) {
        double[] result = new double[values.length];
        int counter = 0;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int t = nArray[n2];
            counter += t;
            ++n2;
        }
        int i = 0;
        while (i < values.length) {
            result[i] = (double)values[i] * 100.0 / (double)counter;
            ++i;
        }
        return result;
    }

    public static double round(double d, int decimalPlaces, RoundingMode roundingMode) {
        try {
            return new BigDecimal(d).setScale(decimalPlaces, roundingMode).doubleValue();
        }
        catch (Exception e) {
            return d;
        }
    }
}

