/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.essentials;

import info.thereisonlywe.core.essentials.LanguageEssentials;
import info.thereisonlywe.core.essentials.LocaleEssentials;
import info.thereisonlywe.core.search.SearchEngine;
import info.thereisonlywe.core.search.SearchModifier;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringEssentials {
    public static final String THEREISONLYWE_LINE_SEPARATOR = ")|(";
    public static final String THEREISONLYWE_VALUE_SEPARATOR = "#:#";

    public static String formatEmail(String email) {
        email = StringEssentials.toASCII(email);
        email = email.replace("..", ".");
        if ((email = email.replace("@.", "@")).startsWith(".")) {
            email = new String(email.substring(1, email.length()));
        }
        if (email.endsWith(".")) {
            email = new String(email.substring(0, email.length() - 1));
        }
        if (!email.contains(".")) {
            int index = email.indexOf("info");
            if (index == -1) {
                index = email.indexOf("com");
            }
            if (index != -1) {
                email = String.valueOf(new String(email.substring(0, index))) + "." + new String(email.substring(index, email.length()));
            }
        }
        return email;
    }

    public static int count(String string, String charactersToLookFor) {
        return StringEssentials.indicesOf(string, charactersToLookFor).length;
    }

    public static String limitCharacters(String s, int maxChars) {
        if (s.length() < maxChars) {
            return s;
        }
        return new String(String.valueOf(s.substring(0, maxChars - 3)) + "...");
    }

    public static String camelCaseToStartCase(String s) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (i != 0 && Character.isUpperCase(c)) {
                sb.append(" ");
            }
            if (i == 0) {
                c = Character.toUpperCase(c);
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static String capitalizeWords(String s) {
        return StringEssentials.capitalizeWords(s, null);
    }

    public static String capitalizeWords(String s, Locale locale) {
        String[] words = StringEssentials.splitWords(s);
        int i = 0;
        while (i < words.length) {
            int x = 1;
            char c = words[i].charAt(0);
            while (words[i].length() > x && (c == '(' || c == '{' || c == '[' || c == '\"' || c == '\'')) {
                c = words[i].charAt(x);
                ++x;
            }
            String tmp = locale == null ? new String(String.valueOf(c)).toUpperCase() : new String(String.valueOf(c)).toUpperCase(locale);
            words[i] = String.valueOf(new String(words[i].substring(0, x - 1))) + tmp + new String(words[i].substring(x));
            ++i;
        }
        return StringEssentials.glue(words, " ");
    }

    public static boolean contains(String[] array, String s) {
        return StringEssentials.contains(array, s, SearchModifier.CONTAINS);
    }

    public static boolean contains(String[] array, String s, SearchModifier sm) {
        if (array == null) {
            return false;
        }
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (SearchEngine.search(element, s, sm)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean contains(ArrayList<String> array, String s, SearchModifier sm) {
        if (array == null) {
            return false;
        }
        for (String element : array) {
            if (!SearchEngine.search(element, s, sm)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(String sentence, String[] phrases, SearchModifier sm) {
        String[] stringArray = phrases;
        int n = phrases.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element != null && element.trim().length() != 0 && !SearchEngine.search(sentence, element, sm)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean containsCharacter(String s, Character.UnicodeBlock u) {
        int l = 0;
        while (l < s.length()) {
            if (Character.UnicodeBlock.of(s.charAt(l)).equals(u)) {
                return true;
            }
            ++l;
        }
        return false;
    }

    public static boolean containsNumeral(String s) {
        return s.matches(".*\\d+.*");
    }

    public static ArrayList<String> cut(String s, String separator) {
        return new ArrayList<String>(Arrays.asList(s.split(separator)));
    }

    public static boolean equals(String s1, String s2) {
        return StringEssentials.equals(s1, s2, LocaleEssentials.LOCALE_DEFAULT);
    }

    public static boolean equals(String s1, String s2, Locale locale) {
        s1 = s1.replace("'", "");
        s1 = s1.toLowerCase(locale);
        s1 = StringEssentials.removeDiacritics(s1);
        s2 = s2.replace("'", "");
        s2 = s2.toLowerCase(locale);
        s2 = StringEssentials.removeDiacritics(s2);
        return s1.equals(s2);
    }

    public static String enclose(String s, char charToBeEnclosed, char charToEncloseWith) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == charToBeEnclosed) {
                sb.append(charToEncloseWith);
                sb.append(charToBeEnclosed);
                sb.append(charToEncloseWith);
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String fetchDelimitedEntry(String s, char delimiter, int entryNo) {
        int i = 1;
        while (i < entryNo) {
            s = new String(s.substring(s.indexOf(delimiter) + 1));
            ++i;
        }
        if (s.contains("" + delimiter)) {
            s = new String(s.substring(0, s.indexOf(delimiter)));
        }
        return s;
    }

    public static String free(String s, char enclosedChar, char enclosingChar) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == enclosingChar && i < s.length() - 2 && s.charAt(i + 1) == enclosedChar && s.charAt(i + 2) == enclosingChar) {
                sb.append(enclosedChar);
                i += 2;
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static int getBlanksUpTo(int caret, String text) {
        int count = 0;
        int i = 0;
        while (i < caret) {
            if (text.charAt(i) == ' ') {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int getIndexOfNextBlank(int caret, String text) {
        int i = caret + 1;
        while (i < text.length()) {
            if (text.charAt(i) == ' ') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getIndexOfNextChar(int caret, String text, char c) {
        int i = caret + 1;
        while (i < text.length()) {
            if (text.charAt(i) == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getIndexOfNthWord(int n, String s) {
        int i = 0;
        while (i < s.length()) {
            if (StringEssentials.getBlanksUpTo(i, s) == n - 1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getIndexOfPreviousBlank(int caret, String text) {
        int i = caret;
        while (i >= 0) {
            if (text.charAt(i) == ' ') {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int getIndexOfPreviousChar(int caret, String text, char c) {
        int i = caret;
        while (i >= 0) {
            if (text.charAt(i) == c) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static String getLongestString(String[] s) {
        long longest = Long.MIN_VALUE;
        int index = 0;
        int i = 0;
        while (i < s.length) {
            if ((long)s[i].length() > longest) {
                longest = s[i].length();
                index = i;
            }
            ++i;
        }
        return s[index];
    }

    public static int getNumberOfDiacritics(String s) {
        int count = 0;
        int i = 0;
        while (i < s.length()) {
            if (LanguageEssentials.Character.isDiacriticMark(s.charAt(i))) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static String getShortestString(String[] s) {
        long shortest = Long.MAX_VALUE;
        int index = 0;
        int i = 0;
        while (i < s.length) {
            if ((long)s[i].length() < shortest) {
                shortest = s[i].length();
                index = i;
            }
            ++i;
        }
        return s[index];
    }

    public static String glue(int[] s, String separator) {
        if (s == null || s.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < s.length - 1) {
            result.append(s[i]);
            result.append(separator);
            ++i;
        }
        result.append(s[s.length - 1]);
        return result.toString();
    }

    public static <T> String glue(List<T> s, char separator) {
        return StringEssentials.glue(s, String.valueOf(separator));
    }

    public static <T> String glue(List<T> s, String separator) {
        if (s.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < s.size() - 1) {
            result.append(s.get(i));
            result.append(separator);
            ++i;
        }
        result.append(s.get(s.size() - 1));
        return result.toString();
    }

    public static <T> String glue(Set<T> words, char separator) {
        return StringEssentials.glue(words, String.valueOf(separator));
    }

    public static <T> String glue(Set<T> words, String separator) {
        if (words.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int counter = 1;
        for (T str : words) {
            if (str == null) continue;
            result.append(str.toString());
            if (counter != words.size()) {
                result.append(separator);
            }
            ++counter;
        }
        return result.toString();
    }

    public static <T> String glue(T[] s, char separator) {
        return StringEssentials.glue(s, String.valueOf(separator));
    }

    public static <T> String glue(T[] s, String separator) {
        if (s == null || s.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < s.length - 1) {
            result.append(s[i].toString());
            result.append(separator);
            ++i;
        }
        result.append(s[s.length - 1]);
        return result.toString();
    }

    public static String indentParagraph(String s, String indent) {
        if (s == null) {
            return null;
        }
        s = String.valueOf(indent) + s;
        s = s.replace("\n", "\n".concat(indent));
        return s;
    }

    public static String[] indentParagraph(String[] array, String indent) {
        int i = 0;
        while (i < array.length) {
            array[i] = StringEssentials.indentParagraph(array[i], indent);
            ++i;
        }
        return array;
    }

    public static int[] indicesOf(String sentence, String phrase) {
        return StringEssentials.indicesOf(sentence, phrase, SearchModifier.CONTAINS);
    }

    public static int[] indicesOf(String sentence, String phrase, SearchModifier sm) {
        int i = 0;
        ArrayList<Integer> occurences = new ArrayList<Integer>();
        while (i < sentence.length()) {
            int temp = sentence.indexOf(phrase, i);
            if (temp == -1) break;
            if (sm.equals((Object)SearchModifier.CONTAINS)) {
                occurences.add(temp);
            } else if (sm.equals((Object)SearchModifier.CONTAINS_PHRASE_EXACTLY)) {
                if ((temp + phrase.length() == sentence.length() || Character.isWhitespace(sentence.charAt(temp + phrase.length()))) && (temp == 0 || Character.isWhitespace(sentence.charAt(temp - 1)))) {
                    occurences.add(temp);
                }
            } else if (sm.equals((Object)SearchModifier.CONTAINS_PHRASE_ENDING_WITH)) {
                if (temp + phrase.length() == sentence.length() || Character.isWhitespace(sentence.charAt(temp + phrase.length()))) {
                    occurences.add(temp);
                }
            } else if (sm.equals((Object)SearchModifier.CONTAINS_PHRASE_STARTING_WITH) && (temp == 0 || Character.isWhitespace(sentence.charAt(temp - 1)))) {
                occurences.add(temp);
            }
            i = temp + phrase.length();
        }
        if (occurences.size() <= 0) {
            return new int[0];
        }
        int[] result = new int[occurences.size()];
        int j = 0;
        while (j < result.length) {
            result[j] = (Integer)occurences.get(j);
            ++j;
        }
        return result;
    }

    public static boolean isLowerCase(String s) {
        int i = 0;
        while (i < s.length()) {
            if (Character.isUpperCase(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isUpperCase(String s) {
        int i = 0;
        while (i < s.length()) {
            if (Character.isLowerCase(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean areAlmostSimilar(String s1, String s2) {
        return StringEssentials.areSimilar(s1, s2, 0.5);
    }

    public static boolean areAlmostSimilar(String[] s1, String[] s2) {
        return StringEssentials.areSimilar(s1, s2, 0.5);
    }

    public static boolean areAlmostSimilar(List<String> s1, List<String> s2) {
        return StringEssentials.areSimilar(s1, s2, 0.5);
    }

    public static boolean areSimilar(String s1, String s2) {
        return StringEssentials.areSimilar(s1, s2, 0.75);
    }

    public static boolean areSimilar(String[] s1, String[] s2) {
        return StringEssentials.areSimilar(s1, s2, 0.75);
    }

    public static boolean areSimilar(List<String> s1, List<String> s2) {
        return StringEssentials.areSimilar(s1, s2, 0.75);
    }

    public static boolean areHighlySimilar(String s1, String s2) {
        return StringEssentials.areSimilar(s1, s2, 0.85);
    }

    public static boolean areHighlySimilar(String[] s1, String[] s2) {
        return StringEssentials.areSimilar(s1, s2, 0.85);
    }

    public static boolean areHighlySimilar(List<String> s1, List<String> s2) {
        return StringEssentials.areSimilar(s1, s2, 0.85);
    }

    public static boolean areExceptionallySimilar(String s1, String s2) {
        return StringEssentials.areSimilar(s1, s2, 0.9);
    }

    public static boolean areExceptionallySimilar(String[] s1, String[] s2) {
        return StringEssentials.areSimilar(s1, s2, 0.9);
    }

    public static boolean areExceptionallySimilar(List<String> s1, List<String> s2) {
        return StringEssentials.areSimilar(s1, s2, 0.9);
    }

    public static boolean areAlmostIdentical(String s1, String s2) {
        return StringEssentials.areSimilar(s1, s2, 0.95);
    }

    public static boolean areAlmostIdentical(String[] s1, String[] s2) {
        return StringEssentials.areSimilar(s1, s2, 0.95);
    }

    public static boolean areAlmostIdentical(List<String> s1, List<String> s2) {
        return StringEssentials.areSimilar(s1, s2, 0.95);
    }

    public static boolean areSimilar(String s1, String s2, double percent) {
        return StringEssentials.getSimilarity(s1, s2) >= percent;
    }

    public static boolean areSimilar(List<String> s1, List<String> s2, double percent) {
        return StringEssentials.getSimilarity(StringEssentials.glue(s1, "."), StringEssentials.glue(s2, ".")) >= percent;
    }

    public static boolean areSimilar(String[] s1, String[] s2, double percent) {
        return StringEssentials.getSimilarity(StringEssentials.glue(s1, "."), StringEssentials.glue(s2, ".")) >= percent;
    }

    public static double getSimilarity(String[] s1, String[] s2) {
        return StringEssentials.getSimilarity(StringEssentials.glue(s1, "."), StringEssentials.glue(s2, "."));
    }

    public static double getSimilarity(List<String> s1, List<String> s2) {
        return StringEssentials.getSimilarity(StringEssentials.glue(s1, "."), StringEssentials.glue(s2, "."));
    }

    public static double getSimilarity(String s1, String s2) {
        int bigLen;
        if (s1 == null || s2 == null || s1.equals(s2)) {
            return 1.0;
        }
        if (s1.length() < s2.length()) {
            String swap = s1;
            s1 = s2;
            s2 = swap;
        }
        if ((bigLen = s1.length()) == 0) {
            return 1.0;
        }
        return (double)(bigLen - StringEssentials.computeEditDistance(s1, s2)) / (double)bigLen;
    }

    private static int computeEditDistance(String s1, String s2) {
        s1 = s1.toLowerCase();
        s2 = s2.toLowerCase();
        int[] costs = new int[s2.length() + 1];
        int i = 0;
        while (i <= s1.length()) {
            int lastValue = i;
            int j = 0;
            while (j <= s2.length()) {
                if (i == 0) {
                    costs[j] = j;
                } else if (j > 0) {
                    int newValue = costs[j - 1];
                    if (s1.charAt(i - 1) != s2.charAt(j - 1)) {
                        newValue = Math.min(Math.min(newValue, lastValue), costs[j]) + 1;
                    }
                    costs[j - 1] = lastValue;
                    lastValue = newValue;
                }
                ++j;
            }
            if (i > 0) {
                costs[s2.length()] = lastValue;
            }
            ++i;
        }
        return costs[s2.length()];
    }

    public static <T> String list(double[] array, T[] names) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            sb.append(names[i].toString());
            sb.append(": ");
            sb.append(array[i]);
            if (i + 1 < array.length) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public static <T> String list(int[] array, T[] names) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            sb.append(names[i].toString());
            sb.append(": ");
            sb.append(array[i]);
            if (i + 1 < array.length) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public static <T> String list(T[] array, T[] names) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            sb.append(names[i].toString());
            sb.append(": ");
            sb.append(array[i].toString());
            if (i + 1 < array.length) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public static String multiLine(String s, int maxCharsPerLine) {
        char[] digit = s.toCharArray();
        int count = 0;
        int i = 0;
        while (i < digit.length) {
            if (++count > maxCharsPerLine && digit[i] == ' ') {
                digit[i] = 10;
                count = 0;
            }
            ++i;
        }
        s = new String(digit);
        return s;
    }

    public static String normalizeAleph(String s) {
        return s.replace(LanguageEssentials.Character.ALEPH_WASLA, LanguageEssentials.Character.ALEPH).replace(LanguageEssentials.Character.ALEPH_WAVY_HAMZA_ABOVE, LanguageEssentials.Character.ALEPH).replace(LanguageEssentials.Character.ALEPH_WAVY_HAMZA_BELOW, LanguageEssentials.Character.ALEPH).replace(LanguageEssentials.Character.ALEPH_HIGH_HAMZA, LanguageEssentials.Character.ALEPH).replace(LanguageEssentials.Character.ALEPH_HAMZA_ABOVE, LanguageEssentials.Character.ALEPH).replace(LanguageEssentials.Character.ALEPH_HAMZA_BELOW, LanguageEssentials.Character.ALEPH).replace(LanguageEssentials.Character.ALEPH_SUPERSCRIPT, LanguageEssentials.Character.ALEPH).replace(LanguageEssentials.Character.ALEPH_MADDA, LanguageEssentials.Character.ALEPH).replace(LanguageEssentials.Character.ALEPH_WTF, LanguageEssentials.Character.ALEPH);
    }

    public static String addPaddingToNumber(int number, int numberOfDigits) {
        return StringEssentials.addPaddingToNumber(String.valueOf(number), numberOfDigits);
    }

    public static String addPaddingToNumber(String numberAsString, int numberOfDigits) {
        int dif = numberOfDigits - numberAsString.length();
        if (dif <= 0) {
            return numberAsString;
        }
        String s = "";
        int i = 0;
        while (i < dif) {
            s = String.valueOf(s) + "0";
            ++i;
        }
        s = String.valueOf(s) + numberAsString;
        return s;
    }

    public static String removeAll(String s, char c) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch != c) {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String removeControlCharacters(String s) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (!Character.isISOControl(ch)) {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    public static String[] removeDiacritics(String[] s) {
        int i = 0;
        while (i < s.length) {
            s[i] = StringEssentials.removeDiacritics(s[i]);
            ++i;
        }
        return s;
    }

    public static String removeDiacritics(String s) {
        return StringEssentials.removeDiacritics(s, true, true);
    }

    public static String removeDiacritics(String s, boolean preserveTurkishCharacters, boolean normalizeAleph) {
        if (s == null) {
            return s;
        }
        s = s.replace("|", "VVV");
        s = s.replace("1", "_I_");
        s = s.replace("2", "_II_");
        s = s.replace("3", "_III_");
        s = s.replace("4", "_IV_");
        s = s.replace("5", "_V_");
        s = s.replace("6", "_VI_");
        s = s.replace("7", "_VII_");
        s = s.replace("8", "_VIII_");
        s = s.replace("9", "_IX_");
        if (normalizeAleph) {
            s = StringEssentials.normalizeAleph(s);
        }
        if (preserveTurkishCharacters) {
            s = s.replace("\u011f", "_gggg_");
            s = s.replace("\u00fc", "_uuuu_");
            s = s.replace("\u015f", "_ssss_");
            s = s.replace("\u00e7", "_cccc_");
            s = s.replace("\u00f6", "_oooo_");
            s = s.replace("\u0130", "_IIII_");
            s = s.replace("\u011e", "_GGGG_");
            s = s.replace("\u015e", "_SSSS_");
            s = s.replace("\u00dc", "_UUUU_");
            s = s.replace("\u00c7", "_CCCC_");
            s = s.replace("\u00d6", "_OOOO_");
        }
        String result = "";
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        result = s.replaceAll("[^\\p{L}\\p{Z}\\p{P}]", "");
        result = pattern.matcher(Normalizer.normalize(result, Normalizer.Form.NFD)).replaceAll("");
        result = result.replace("VVV", "|");
        result = result.replace("_I_", "1");
        result = result.replace("_II_", "2");
        result = result.replace("_III_", "3");
        result = result.replace("_IV_", "4");
        result = result.replace("_V_", "5");
        result = result.replace("_VI_", "6");
        result = result.replace("_VII_", "7");
        result = result.replace("_VIII_", "8");
        result = result.replace("_IX_", "9");
        if (preserveTurkishCharacters) {
            result = result.replace("_gggg_", "\u011f");
            result = result.replace("_uuuu_", "\u00fc");
            result = result.replace("_ssss_", "\u015f");
            result = result.replace("_cccc_", "\u00e7");
            result = result.replace("_oooo_", "\u00f6");
            result = result.replace("_IIII_", "\u0130");
            result = result.replace("_GGGG_", "\u011e");
            result = result.replace("_SSSS_", "\u015e");
            result = result.replace("_UUUU_", "\u00dc");
            result = result.replace("_CCCC_", "\u00c7");
            result = result.replace("_OOOO_", "\u00d6");
        }
        if (LanguageEssentials.Character.isValid(result)) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < result.length()) {
                char c = result.charAt(i);
                if (c != LanguageEssentials.Character.HAMZA_ABOVE.charAt(0) && c != LanguageEssentials.Character.HAMZA_BELOW.charAt(0) && c != LanguageEssentials.Character.MADDAH.charAt(0) && c != '\u06e6' && c != '\u0640' && c != '\u06e5') {
                    sb.append(c);
                }
                ++i;
            }
            result = null;
            return sb.toString();
        }
        return result;
    }

    public static LinkedHashSet<String> removeDuplicates(List<String> s) {
        return new LinkedHashSet<String>(s);
    }

    public static String removeConsecutiveCharacters(String s, int maxAllowedRepetition) {
        return s.replaceAll("(.)\\1{" + maxAllowedRepetition + ",}", "$1");
    }

    public static String removeConsecutiveLetters(String s, int maxAllowedRepetition) {
        return s.replaceAll("(\\p{L}\\p{M}*)\\1{" + maxAllowedRepetition + ",}", "$1");
    }

    public static LinkedHashSet<String> removeDuplicates(String s) {
        return StringEssentials.removeDuplicates(StringEssentials.toStringList(s));
    }

    public static LinkedHashSet<String> removeDuplicates(String[] s) {
        LinkedHashSet<String> lines = new LinkedHashSet<String>(s.length);
        String[] stringArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            lines.add(element);
            ++n2;
        }
        return lines;
    }

    public static String[] removeEmptyEntriesFromArray(String[] array) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < array.length) {
            if (array[i] != null && !array[i].equals("")) {
                result.add(array[i]);
            }
            ++i;
        }
        String[] res = new String[result.size()];
        result.toArray(res);
        return res;
    }

    public static String[] removeEntriesFromArray(String[] array, String stringToBeRemoved) {
        if (array == null) {
            return null;
        }
        if (array.length == 1) {
            return array[0] == null || array[0].equals(stringToBeRemoved) ? null : array;
        }
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < array.length) {
            if (!array[i].equals(stringToBeRemoved)) {
                result.add(array[i]);
            }
            ++i;
        }
        String[] res = new String[result.size()];
        result.toArray(res);
        return res;
    }

    public static String removeForeignChars(String s, Character.UnicodeBlock[] CharacterUnicodeBlocks) {
        if (s == null || s.equals("") || s.equals(" ")) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == ' ') {
                sb.append(c);
            } else {
                int z = 0;
                while (z < CharacterUnicodeBlocks.length) {
                    if (Character.UnicodeBlock.of(c).equals(CharacterUnicodeBlocks[z])) {
                        sb.append(c);
                        break;
                    }
                    ++z;
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String removeForeignChars(String s, Character.UnicodeBlock CharacterUnicodeBlock) {
        return StringEssentials.removeForeignChars(s, new Character.UnicodeBlock[]{CharacterUnicodeBlock});
    }

    public static String[] removeSimilarEntriesFromArray(String[] array, String stringToBeRemoved) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < array.length) {
            if (!array[i].contains(stringToBeRemoved)) {
                result.add(array[i]);
            }
            ++i;
        }
        String[] res = new String[result.size()];
        result.toArray(res);
        return res;
    }

    public static String[] removeEntriesFromArray(String[] array, String[] stringsToBeRemoved) {
        String[] stringArray = stringsToBeRemoved;
        int n = stringsToBeRemoved.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            array = StringEssentials.removeEntriesFromArray(array, element);
            ++n2;
        }
        return array;
    }

    public static String[] removeSimilarEntriesFromArray(String[] array, String[] stringsToBeRemoved) {
        String[] stringArray = stringsToBeRemoved;
        int n = stringsToBeRemoved.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            array = StringEssentials.removeSimilarEntriesFromArray(array, element);
            ++n2;
        }
        return array;
    }

    public static String removeNumbers(String x) {
        x = x.replace("0", "");
        x = x.replace("1", "");
        x = x.replace("2", "");
        x = x.replace("3", "");
        x = x.replace("4", "");
        x = x.replace("5", "");
        x = x.replace("6", "");
        x = x.replace("7", "");
        x = x.replace("8", "");
        x = x.replace("9", "");
        return x;
    }

    public static String removeNonNumbers(String x) {
        return x.replaceAll("[^\\d]", "");
    }

    public static String removeNonTextCharacters(String x) {
        x = x.replace(";", "");
        x = x.replace(":", "");
        x = x.replace("-", "");
        x = x.replace("_", "");
        x = x.replace("?", "");
        x = x.replace("!", "");
        x = x.replace(",", "");
        x = x.replace(".", "");
        x = x.replace("&", "");
        x = x.replace("(", "");
        x = x.replace(")", "");
        x = x.replace("<", "");
        x = x.replace(">", "");
        x = x.replace("{", "");
        x = x.replace("}", "");
        x = x.replace("[", "");
        x = x.replace("]", "");
        x = x.replace("\"", "");
        x = x.replace("/", "");
        x = x.replace("\u2019", "");
        x = x.replace("\u2018", "");
        x = x.replace("\u2013", "");
        x = x.replace("\u201d", "");
        x = x.replace("\u201c", "");
        x = x.replace("*", "");
        x = x.replace("\u00bb", "");
        x = x.replace("\u00ab", "");
        x = x.replace("'", "");
        x = x.replace("\u00b4", "");
        x = x.replace("\u2014", "");
        x = x.replace("|", "");
        return x;
    }

    public static String removeBlanks(String s) {
        return s.replace(" ", "").replace("\u00a0", "").replace("\u202f", "").replace("\ufeff", "");
    }

    public static String[] removePunctuation(String[] s) {
        int i = 0;
        while (i < s.length) {
            s[i] = StringEssentials.removePunctuation(s[i]);
            ++i;
        }
        return StringEssentials.removeEmptyEntriesFromArray(s);
    }

    public static String removePunctuation(String s) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            if (!LanguageEssentials.Character.isQuranicPauseMark(s.charAt(i)) && (Character.isLetterOrDigit(s.charAt(i)) || LanguageEssentials.Character.isValid(s.charAt(i)))) {
                result.append(s.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    public static String replaceMatches(String s, Pattern p, String replacement) {
        Matcher m = p.matcher(s);
        while (m.find()) {
            s = s.replace(m.group(), replacement);
        }
        return s;
    }

    public static String[] replace(String[] array, String OLD, String NEW) {
        int i = 0;
        while (i < array.length) {
            array[i] = array[i].replace(OLD, NEW);
            ++i;
        }
        return array;
    }

    public static String replaceWeirdBlanks(String s) {
        return s.replace("\u00a0", " ").replace("\u202f", " ").replace("\ufeff", " ");
    }

    public static String reverseWordOrder(String s) {
        String[] words = StringEssentials.splitWords(s);
        StringBuilder sb = new StringBuilder();
        int i = words.length - 1;
        while (i >= 0) {
            sb.append(words[i]);
            if (i - 1 >= 0) {
                sb.append(" ");
            }
            --i;
        }
        return sb.toString();
    }

    public static String[] reverseWordOrder(String[] s) {
        String[] result = new String[s.length];
        int i = 0;
        while (i < s.length) {
            result[i] = StringEssentials.reverseWordOrder(s[i]);
            ++i;
        }
        return result;
    }

    public static String scatterChar(String s, char charToScatter) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            sb.append(s.charAt(i));
            sb.append(charToScatter);
            ++i;
        }
        return sb.toString();
    }

    public static String[] splitLines(String s) {
        return s.split("\\r?\\n");
    }

    public static String[] splitStatement(String s, char separator) {
        String[] array = new String[2];
        int i = s.indexOf(separator);
        if (i == -1) {
            array[0] = s;
            return array;
        }
        array[0] = new String(s.substring(0, i));
        array[1] = new String(s.substring(i + 1));
        return array;
    }

    public static String[] splitStatement(String s, String separator) {
        String[] array = new String[2];
        int i = s.indexOf(separator);
        if (i == -1) {
            array[0] = s;
            return array;
        }
        array[0] = new String(s.substring(0, i));
        array[1] = new String(s.substring(i + 1));
        return array;
    }

    public static String[][] splitStatement(String[] s, char separator) {
        String[][] res = new String[2][s.length];
        int i = 0;
        while (i < s.length) {
            res[0][i] = StringEssentials.splitStatement(s[i], separator)[0];
            res[1][i] = StringEssentials.splitStatement(s[i], separator)[1];
            ++i;
        }
        return res;
    }

    public static String[] splitWords(String s) {
        return StringEssentials.removeEmptyEntriesFromArray(s.split(" "));
    }

    public static String toASCII(String s) {
        return Normalizer.normalize(s, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
    }

    public static String toHTMLString(String s) {
        StringBuilder builder = new StringBuilder();
        boolean previousWasASpace = false;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                char c;
                block13: {
                    block10: {
                        block11: {
                            c = cArray[n2];
                            if (c != ' ') break block10;
                            if (!previousWasASpace) break block11;
                            builder.append("&nbsp;");
                            previousWasASpace = false;
                            break block12;
                        }
                        previousWasASpace = true;
                        break block13;
                    }
                    previousWasASpace = false;
                }
                switch (c) {
                    case '<': {
                        builder.append("&lt;");
                        break;
                    }
                    case '>': {
                        builder.append("&gt;");
                        break;
                    }
                    case '&': {
                        builder.append("&amp;");
                        break;
                    }
                    case '\"': {
                        builder.append("&quot;");
                        break;
                    }
                    case '\n': {
                        builder.append("<br>");
                        break;
                    }
                    case '\t': {
                        builder.append("&nbsp; &nbsp; &nbsp;");
                        break;
                    }
                    default: {
                        if (c < '\u0080') {
                            builder.append(c);
                            break;
                        }
                        builder.append("&#").append((int)c).append(";");
                    }
                }
            }
            ++n2;
        }
        return builder.toString();
    }

    public static String toHTMLString(String[] parts) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><table><tr>");
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            sb.append("<td>");
            sb.append(part);
            sb.append("</td>");
            ++n2;
        }
        sb.append("</tr></table></html>");
        return sb.toString();
    }

    public static String toHTMLTable(String[] columns, String[][] rows) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" /></head><table border=\"1\" width=\"95%\">");
        sb.append("<tr>");
        int i = 0;
        while (i < columns.length) {
            sb.append("<th>");
            sb.append(columns[i]);
            sb.append("</th>");
            ++i;
        }
        sb.append("</tr>");
        i = 0;
        while (i < rows.length) {
            sb.append("<tr>");
            int j = 0;
            while (j < columns.length) {
                sb.append("<td>");
                sb.append(rows[i][j]);
                sb.append("</td>");
                ++j;
            }
            sb.append("</tr>");
            ++i;
        }
        sb.append("</table>");
        sb.append("</html>");
        return sb.toString();
    }

    public static String[] toStringArray(String s) {
        char[] c = s.toCharArray();
        String[] result = new String[c.length];
        int i = 0;
        while (i < c.length) {
            result[i] = String.valueOf(c[i]);
            ++i;
        }
        return result;
    }

    public static List<String> toStringList(String s) {
        char[] c = s.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        char[] cArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            list.add(String.valueOf(element));
            ++n2;
        }
        return list;
    }

    public static String unescapeUnicode(String s) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\\' && s.charAt(i + 1) == 'u') {
                String t = new String(s.substring(i, i + 6));
                char c = (char)Integer.parseInt(new String(t.substring(2)), 16);
                sb.append(c);
                i += 5;
            } else {
                sb.append(s.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }
}

