/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.objects;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class IntegerQueue
extends LinkedList<Integer>
implements Queue<Integer> {
    private final int maxSize;

    public IntegerQueue(String representation) {
        this.maxSize = -1;
        if (representation == null || representation.trim().length() == 0) {
            return;
        }
        String[] temp = representation.split(";");
        int i = 0;
        while (i < temp.length) {
            this.add(Integer.parseInt(temp[i]));
            ++i;
        }
    }

    public IntegerQueue(String representation, int maxSize) {
        this.maxSize = maxSize;
        if (representation == null || representation.trim().length() == 0) {
            return;
        }
        String[] temp = representation.split(";");
        int i = 0;
        while (i < Math.min(maxSize, temp.length)) {
            this.add(Integer.parseInt(temp[i]));
            ++i;
        }
    }

    public String asString(int maxSize) {
        if (this.size() == 0) {
            return "";
        }
        String s = "";
        int i = 0;
        while (i < (maxSize < 0 ? this.size() : Math.min(maxSize, this.size()))) {
            s = String.valueOf(s) + String.valueOf(this.get(i));
            if (i + 1 < this.size()) {
                s = String.valueOf(s) + ";";
            }
            ++i;
        }
        return s;
    }

    public String asString() {
        return this.asString(this.maxSize);
    }

    @Override
    public boolean add(Integer i) {
        this.add(i, this.maxSize, true);
        return true;
    }

    public void add(Integer i, boolean allowDuplicates) {
        this.add(i, this.maxSize, allowDuplicates);
    }

    public void add(Integer i, int maxSize) {
        this.add(i, maxSize, true);
    }

    public void add(Integer i, int maxSize, boolean allowDuplicates) {
        int index;
        if (!allowDuplicates && (index = this.indexOf(i)) > -1) {
            this.remove(index);
        }
        while (maxSize >= 1 && this.size() >= maxSize) {
            this.pollFirst();
        }
        super.add(i);
    }

    @Override
    public boolean addAll(Collection<? extends Integer> arg0) {
        return super.addAll(arg0);
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return super.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return super.containsAll(arg0);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public Iterator<Integer> iterator() {
        return super.iterator();
    }

    @Override
    public boolean remove(Object arg0) {
        return super.remove(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return super.removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return super.retainAll(arg0);
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public Object[] toArray() {
        return super.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return super.toArray(arg0);
    }

    @Override
    public Integer element() {
        return (Integer)super.element();
    }

    @Override
    public boolean offer(Integer arg0) {
        return super.offer(arg0);
    }

    @Override
    public Integer peek() {
        return (Integer)super.peek();
    }

    @Override
    public Integer poll() {
        return (Integer)super.poll();
    }

    @Override
    public Integer remove() {
        return (Integer)super.remove();
    }
}

