/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.objects;

import info.thereisonlywe.core.essentials.TimeEssentials;
import info.thereisonlywe.core.objects.SequentialRange;

public class TimeRange
implements SequentialRange<String> {
    public final String start;
    public final String end;

    public TimeRange(String start, String end) {
        this.start = start;
        this.end = end;
    }

    public TimeRange(String fromToString) {
        int index = fromToString.indexOf(",");
        this.start = new String(fromToString.substring(1, index));
        this.end = new String(fromToString.substring(index + 2, fromToString.indexOf("]")));
    }

    public String toString() {
        return "[" + this.start + ", " + this.end + "]";
    }

    @Override
    public boolean isInRange(String k) {
        return TimeEssentials.getTimeDifference(this.start, k) >= 0L && TimeEssentials.getTimeDifference(k, this.end) >= 0L;
    }

    public String getRange() {
        return TimeEssentials.formatTime(0L, 0L, TimeEssentials.getTimeDifference(this.start, this.end));
    }
}

