/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.objects;

import java.util.ArrayList;
import java.util.HashSet;

public class WordPool {
    private final ArrayList<HashSet<String>> pool = new ArrayList();
    private final ArrayList<Character> indices = new ArrayList();

    public synchronized void add(String word) {
        Character c = Character.valueOf(word.charAt(0));
        int index = this.indices.indexOf(c);
        if (index == -1) {
            this.indices.add(c);
            this.pool.add(new HashSet());
            this.pool.get(this.indices.size() - 1).add(word);
        } else {
            this.pool.get(index).add(word);
        }
    }

    public void add(String[] words) {
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            this.add(word);
            ++n2;
        }
    }

    public synchronized boolean contains(String word) {
        return this.pool.get(this.indices.indexOf(Character.valueOf(word.charAt(0)))).contains(word);
    }

    public boolean containsWordsLike(String word) {
        Character c = Character.valueOf(word.charAt(0));
        int index = this.indices.indexOf(c);
        if (index == -1) {
            return false;
        }
        for (String str : this.pool.get(index)) {
            if (!str.startsWith(word)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<String> getWordsLike(String word) {
        Character c = Character.valueOf(word.charAt(0));
        int index = this.indices.indexOf(c);
        if (index == -1) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String str : this.pool.get(index)) {
            if (!str.startsWith(word)) continue;
            result.add(str);
        }
        return result;
    }

    public synchronized void remove(String word) {
        Character c = Character.valueOf(word.charAt(0));
        int index = this.indices.indexOf(c);
        this.pool.get(index).remove(word);
        if (this.pool.get(index).isEmpty()) {
            this.pool.remove(index);
        }
    }
}

