/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.ontology;

import info.thereisonlywe.core.essentials.LocaleEssentials;
import info.thereisonlywe.core.ontology.Temperament;

public enum Element {
    AIR(Temperament.MOIST_HOT),
    WATER(Temperament.MOIST_COLD),
    FIRE(Temperament.DRY_HOT),
    EARTH(Temperament.DRY_COLD);

    public final Temperament temperament;

    private Element(Temperament t) {
        this.temperament = t;
    }

    public String getName(String lang) {
        if (lang.equals("tr")) {
            switch (this.ordinal()) {
                case 0: {
                    return "Hava";
                }
                case 1: {
                    return "Su";
                }
                case 2: {
                    return "Ate\u015f";
                }
                case 3: {
                    return "Toprak";
                }
            }
        } else {
            switch (this.ordinal()) {
                case 0: {
                    return "Air";
                }
                case 1: {
                    return "Water";
                }
                case 2: {
                    return "Fire";
                }
                case 3: {
                    return "Earth";
                }
            }
        }
        return null;
    }

    public Element getOpposite() {
        switch (this.ordinal()) {
            case 0: {
                return EARTH;
            }
            case 1: {
                return FIRE;
            }
            case 2: {
                return WATER;
            }
            case 3: {
                return AIR;
            }
        }
        return null;
    }

    public String toString() {
        return this.getName(LocaleEssentials.LANGUAGE_DEFAULT);
    }
}

