/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.toolkit;

import info.thereisonlywe.core.essentials.LocaleEssentials;
import info.thereisonlywe.core.essentials.MathEssentials;
import info.thereisonlywe.core.essentials.StringEssentials;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextFormatter {
    public static String fix(String text) {
        return TextFormatter.format(text, null);
    }

    public static String format(String text, TextFormatSpecs specs) {
        StringBuilder sb;
        if (specs == null) {
            specs = new TextFormatSpecs();
        }
        if (specs.fix) {
            text = StringEssentials.removeConsecutiveLetters(StringEssentials.replaceWeirdBlanks(text), specs.maxAllowedConsecutiveLetters).replace("         ", " ").replace("       ", " ").replace("     ", " ").replace("   ", " ").replace("  ", " ").replace("\" \" \"", "\"").replace("\" \"", "\"").replace("\"\"", "\"").replace(", , ,", ",").replace(",,,", ",").replace(", ,", ",").replace(",,", ",").replace(". . .", ".").replace("...", ".").replace(". .", ".").replace("..", ".").replace("; ; ;", ";").replace(";;;", ";").replace("; ;", ";").replace(";;", ";").replace(": : :", ":").replace(":::", ":").replace(": :", ":").replace("::", ":").replace("! ! !", "!").replace("!!!", "!").replace("! !", "!").replace("!!", "!").replace("? ? ?", "?").replace("???", "?").replace("? ?", "?").replace("??", "?").replace("' ' '", "'").replace("'''", "'").replace("' '", "'").replace("''", "'").replace("\u201c \u201c \u201c", "\u201c").replace("\u201c\u201c\u201c", "\u201c").replace("\u201c \u201c", "\u201c").replace("\u201c\u201c", "\u201c").replace("\u201d \u201d \u201d", "\u201d").replace("\u201d\u201d\u201d", "\u201d").replace("\u201d \u201d", "\u201d").replace("\u201d\u201d", "\u201d").replace("\u00ab \u00ab \u00ab", "\u00ab").replace("\u00ab\u00ab\u00ab", "\u00ab").replace("\u00ab \u00ab", "\u00ab").replace("\u00ab\u00ab", "\u00ab").replace("\u00bb \u00bb \u00bb", "\u00bb").replace("\u00bb\u00bb\u00bb", "\u00bb").replace("\u00bb \u00bb", "\u00bb").replace("\u00bb\u00bb", "\u00bb").replace("\u2018 \u2018 \u2018", "\u2018").replace("\u2018\u2018\u2018", "\u2018").replace("\u2018 \u2018", "\u2018").replace("\u2018\u2018", "\u2018").replace("\u2019 \u2019 \u2019", "\u2019").replace("\u2019\u2019\u2019", "\u2019").replace("\u2019 \u2019", "\u2019").replace("\u2019\u2019", "\u2019").replace("\u00b4 \u00b4 \u00b4", "\u00b4").replace("\u00b4\u00b4\u00b4", "\u00b4").replace("\u00b4 \u00b4", "\u00b4").replace("\u00b4\u00b4", "\u00b4").replaceAll("(\r?\n){3,}", "\n\n");
        }
        if (specs.fix) {
            sb = new StringBuilder();
            sb.ensureCapacity(text.length());
            int i = 0;
            while (i < text.length()) {
                String c = String.valueOf(text.charAt(i));
                if (c.equals(",") || c.equals(".") || c.equals("?") || c.equals("!") || c.equals(":") || c.equals(";") || c.equals("\u201c") || c.equals("\u201d") || c.equals("\u00ab") || c.equals("\u00bb") || c.equals("\u2018") || c.equals("\u2019") || c.equals("'") || c.equals("\u00b4")) {
                    String before;
                    int p = 0;
                    if (i > 0 && (c.equals(",") || c.equals(".") || c.equals("?") || c.equals("!") || c.equals(":") || c.equals(";") || c.equals("\u201d") || c.equals("\u2019") || c.equals("\u00bb") || p == 1) && (before = String.valueOf(text.charAt(i - 1))).equals(" ")) {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    if (i + 1 < text.length()) {
                        String after = String.valueOf(text.charAt(i + 1));
                        if ((c.equals("\u201c") || c.equals("\u2018") || c.equals("\u00ab") || p == -1) && after.equals(" ")) {
                            ++i;
                        } else if ((c.equals(",") || c.equals(".") || c.equals("?") || c.equals("!") || c.equals(":") || c.equals(";")) && !after.equals(" ")) {
                            char c_ = after.charAt(0);
                            if (!c.equals(".") || !Character.isDigit(c_) && c_ != '\"' && c_ != '\u201c' && c_ != '\u2018' && c_ != '\u00ab' && c_ != '\'' && c_ != '\u00b4') {
                                c = String.valueOf(c) + " ";
                            }
                        }
                    }
                } else if (c.equals("\"") && i + 1 < text.length() && i > 0) {
                    String t;
                    if (sb.charAt(sb.length() - 1) == ' ') {
                        c = c.concat(String.valueOf(text.charAt(i + 1)).toUpperCase(specs.locale));
                        ++i;
                    } else if (sb.charAt(sb.length() - 1) == '.' && !(t = String.valueOf(text.charAt(i + 1)).toUpperCase(specs.locale)).equals(" ")) {
                        c = c.concat(" ").concat(String.valueOf(text.charAt(i + 1)).toUpperCase(specs.locale));
                        ++i;
                    }
                }
                sb.append(c);
                ++i;
            }
            text = sb.toString();
        }
        Matcher matcher = null;
        Pattern p1 = null;
        Pattern p2 = null;
        if (specs.fix) {
            p1 = Pattern.compile("(\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\")");
            p2 = Pattern.compile("('[^'\\\\]*(?:\\\\.[^'\\\\]*)*')");
        }
        String[] lines = StringEssentials.splitLines(text);
        int i = 0;
        while (i < lines.length) {
            if (specs.removeDiacricitics) {
                lines[i] = StringEssentials.removeDiacritics(lines[i]);
            }
            if (specs.fix) {
                lines[i] = lines[i].trim().replace("         ", " ").replace("       ", " ").replace("     ", " ").replace("   ", " ").replace("  ", " ");
            }
            if (!lines[i].equals("")) {
                char c;
                if (specs.fix) {
                    sb = new StringBuilder();
                    String tmp = String.valueOf(lines[i].charAt(0));
                    if (StringEssentials.isLowerCase(tmp)) {
                        sb.append(tmp.toUpperCase(specs.locale));
                    } else {
                        sb.append(tmp);
                    }
                    int j = 1;
                    while (j < lines[i].length()) {
                        c = lines[i].charAt(j);
                        if ((c == '.' || c == ':' || c == '?' || c == '!') && j + 1 < lines[i].length()) {
                            char n = lines[i].charAt(j + 1);
                            if (n != ' ') {
                                sb.append(c);
                                sb.append(String.valueOf(n).toUpperCase(specs.locale));
                                ++j;
                            } else if (j + 2 < lines[i].length()) {
                                sb.append(c);
                                sb.append(n);
                                String s = String.valueOf(lines[i].charAt(j + 2));
                                String s_ = s.toUpperCase(specs.locale);
                                sb.append(s_);
                                if (s.equals(s_)) {
                                    if (j + 3 < lines[i].length()) {
                                        String s2 = String.valueOf(lines[i].charAt(j + 3));
                                        String s2_ = s2.toUpperCase(specs.locale);
                                        sb.append(s2_);
                                        if (!s2.equals(s2_)) {
                                            j += 3;
                                        } else if (j + 4 < lines[i].length()) {
                                            String s3 = String.valueOf(lines[i].charAt(j + 4));
                                            String s3_ = s3.toUpperCase(specs.locale);
                                            sb.append(s3_);
                                            j += 4;
                                        } else {
                                            j += 3;
                                        }
                                    } else {
                                        j += 2;
                                    }
                                } else {
                                    j += 2;
                                }
                            }
                        } else {
                            sb.append(c);
                        }
                        ++j;
                    }
                    lines[i] = sb.toString();
                }
                if (specs.fix) {
                    String[] words = StringEssentials.splitWords(lines[i]);
                    int k = 0;
                    while (k < words.length) {
                        String[] temp = words[k].split("-");
                        if (temp.length > 0) {
                            int m = 0;
                            while (m < temp.length) {
                                if (temp[m].length() > 1) {
                                    int index = 0;
                                    char c2 = temp[m].charAt(0);
                                    if (c2 == '\"' || c2 == '\u201c' || c2 == '\u2018' || c2 == '\u00ab' || c2 == '\'' || c2 == '\u00b4') {
                                        ++index;
                                    }
                                    temp[m] = new String(temp[m].substring(0, index)).concat(new String(temp[m].substring(index, index + 1))).concat(new String(temp[m].substring(index + 1)).toLowerCase(specs.locale));
                                }
                                ++m;
                            }
                            words[k] = StringEssentials.glue(temp, "-");
                        } else if (words[k].length() > 1) {
                            int index = 0;
                            char c3 = words[k].charAt(0);
                            if (c3 == '\"' || c3 == '\u201c' || c3 == '\u2018' || c3 == '\u00ab' || c3 == '\'' || c3 == '\u00b4') {
                                ++index;
                            }
                            words[k] = new String(words[k].substring(0, index)).concat(new String(words[k].substring(index, index + 1))).concat(new String(words[k].substring(index + 1).toLowerCase(specs.locale)));
                        }
                        ++k;
                    }
                    lines[i] = StringEssentials.glue(words, " ");
                }
                if (specs.encloseTitle && Character.isLetter(lines[i].charAt(lines[i].length() - 1))) {
                    int b;
                    int a = lines[i].lastIndexOf(46);
                    int max = MathEssentials.getMaxValue(new int[]{a, b = lines[i].lastIndexOf(63), c = lines[i].lastIndexOf(33)});
                    lines[i] = max == -1 ? String.valueOf(specs.encloseBeginChar) + lines[i] + specs.encloseEndChar : (lines[i].length() <= max + 1 || lines[i].charAt(max + 1) != ' ' ? String.valueOf(new String(lines[i].substring(0, max + 1))) + specs.encloseBeginChar + new String(lines[i].substring(max + 1)).trim() + specs.encloseEndChar : String.valueOf(new String(lines[i].substring(0, max + 2))) + specs.encloseBeginChar + new String(lines[i].substring(max + 2)).trim() + specs.encloseEndChar);
                }
                if (specs.indentParagraphs) {
                    lines[i] = StringEssentials.indentParagraph(lines[i], specs.indent);
                }
                if (specs.fix) {
                    matcher = p1.matcher(lines[i]);
                    while (matcher.find()) {
                        lines[i] = lines[i].replace(matcher.group(), matcher.group().trim());
                    }
                    matcher = p2.matcher(lines[i]);
                    while (matcher.find()) {
                        lines[i] = lines[i].replace(matcher.group(), matcher.group().trim());
                    }
                }
            }
            ++i;
        }
        text = StringEssentials.glue(lines, "\n");
        return text;
    }

    public static class TextFormatSpecs {
        boolean fix;
        boolean encloseTitle = false;
        boolean indentParagraphs = false;
        boolean removeDiacricitics = false;
        Locale locale = LocaleEssentials.LOCALE_DEFAULT;
        char encloseBeginChar = (char)40;
        char encloseEndChar = (char)41;
        String indent = "\t";
        int maxAllowedConsecutiveLetters = 2;

        public TextFormatSpecs(boolean fix, boolean indentParagraphs, boolean encloseTitle, boolean removeDiacritics, Locale locale) {
            this.fix = fix;
            this.encloseTitle = encloseTitle;
            this.indentParagraphs = indentParagraphs;
            this.removeDiacricitics = removeDiacritics;
            if (locale != null) {
                this.locale = locale;
            }
        }

        public TextFormatSpecs() {
            this.fix = true;
        }

        public void setEncloseChars(char begin, char end) {
            this.encloseBeginChar = begin;
            this.encloseEndChar = end;
        }

        public void setIndent(String indent) {
            this.indent = indent;
        }
    }
}

