/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.emailer;

import info.thereisonlywe.core.essentials.IOEssentials;
import info.thereisonlywe.core.essentials.StringEssentials;
import java.awt.Desktop;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class Emailer {
    private int port = 465;
    private String host = "smtp.example.com";
    private String from = "matt@example.com";
    private boolean auth = true;
    private String username = "matt@example.com";
    private String password = "secretpw";
    private String senderName = null;
    private Protocol protocol = Protocol.SMTP;
    private File[] attachments = null;
    private boolean requestFeedback = true;
    private boolean sendACopy = false;
    private boolean debug = false;

    static {
        System.setProperty("mail.mime.charset", "UTF-8");
    }

    public void setAttachments(File[] files) {
        this.attachments = files;
    }

    public void setAttachment(File file) {
        this.attachments = new File[]{file};
    }

    public void setRequestFeedback(boolean requestFeedback) {
        this.requestFeedback = requestFeedback;
    }

    public void setSendACopy(boolean sendACopy) {
        this.sendACopy = sendACopy;
    }

    public void setSenderName(String name) {
        this.senderName = name;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setAuthorization(boolean auth) {
        this.auth = auth;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String pw) {
        this.password = pw;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private void addAttachment(Multipart multipart, File f) throws MessagingException {
        FileDataSource source = new FileDataSource(f);
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
        messageBodyPart.setFileName(f.getName());
        multipart.addBodyPart(messageBodyPart);
    }

    public void send(String to, String subject, String body, String name) throws MessagingException, UnsupportedEncodingException {
        Properties props = new Properties();
        props.put("mail.smtp.host", this.host);
        props.put("mail.smtp.port", (Object)this.port);
        switch (this.protocol) {
            case SMTPS: {
                props.put("mail.smtp.ssl.enable", (Object)true);
                break;
            }
            case TLS: {
                props.put("mail.smtp.starttls.enable", (Object)true);
            }
        }
        Authenticator authenticator = null;
        if (this.auth) {
            props.put("mail.smtp.auth", (Object)true);
            authenticator = new Authenticator(){
                private PasswordAuthentication pa;
                {
                    this.pa = new PasswordAuthentication(Emailer.this.username, Emailer.this.password);
                }

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return this.pa;
                }
            };
        }
        Session session = Session.getInstance(props, authenticator);
        session.setDebug(this.debug);
        MimeMessage message = new MimeMessage(session);
        if (name != null && name.length() > 0) {
            String[] parts = StringEssentials.splitWords(name);
            body = body.replace("_RECIPIENT-NAME_", name);
            body = body.replace("_RECIPIENT-FNAME_", parts[0]);
            body = body.replace("_RECIPIENT-LNAME_", parts[parts.length - 1]);
        }
        MimeMultipart m = null;
        if (this.attachments != null) {
            m = new MimeMultipart();
            int i = 0;
            while (i < this.attachments.length) {
                this.addAttachment(m, this.attachments[i]);
                ++i;
            }
        }
        if (m == null) {
            message.setText(body, "UTF-8");
        } else {
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent(body, "text/plain");
            ((Multipart)m).addBodyPart(messageBodyPart);
            message.setContent(m);
        }
        message = this.prepareToSend(to, subject, message);
        Transport.send(message);
    }

    public void send(String to, String subject, String body, String name, String type) throws MessagingException, IOException {
        if (body.contains("<html>")) {
            this.send(to, subject, this.createHTMLMultiPartFromHTMLString(body, name), null);
            return;
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", this.host);
        props.put("mail.smtp.port", (Object)this.port);
        switch (this.protocol) {
            case SMTPS: {
                props.put("mail.smtp.ssl.enable", (Object)true);
                break;
            }
            case TLS: {
                props.put("mail.smtp.starttls.enable", (Object)true);
            }
        }
        Authenticator authenticator = null;
        if (this.auth) {
            props.put("mail.smtp.auth", (Object)true);
            authenticator = new Authenticator(){
                private PasswordAuthentication pa;
                {
                    this.pa = new PasswordAuthentication(Emailer.this.username, Emailer.this.password);
                }

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return this.pa;
                }
            };
        }
        Session session = Session.getInstance(props, authenticator);
        session.setDebug(this.debug);
        MimeMessage message = new MimeMessage(session);
        if (name != null && name.length() > 0) {
            String[] parts = StringEssentials.splitWords(name);
            body = body.replace("_RECIPIENT-NAME_", name);
            body = body.replace("_RECIPIENT-FNAME_", parts[0]);
            body = body.replace("_RECIPIENT-LNAME_", parts[parts.length - 1]);
        }
        MimeMultipart m = null;
        m = new MimeMultipart();
        if (this.attachments != null) {
            int i = 0;
            while (i < this.attachments.length) {
                this.addAttachment(m, this.attachments[i]);
                ++i;
            }
        }
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent(body, type.toLowerCase().contains("html") ? "text/html" : "text/plain");
        ((Multipart)m).addBodyPart(messageBodyPart);
        message.setContent(m);
        message = this.prepareToSend(to, subject, message);
        Transport.send(message);
    }

    public void send(String to, String subject, File f, String name) throws MessagingException, IOException {
        if (f.getName().endsWith(".html") || f.getName().endsWith(".htm")) {
            this.send(to, subject, this.createHTMLMultiPartFromHTMLString(IOEssentials.readString(f), name), null);
            return;
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", this.host);
        props.put("mail.smtp.port", (Object)this.port);
        switch (this.protocol) {
            case SMTPS: {
                props.put("mail.smtp.ssl.enable", (Object)true);
                break;
            }
            case TLS: {
                props.put("mail.smtp.starttls.enable", (Object)true);
            }
        }
        Authenticator authenticator = null;
        if (this.auth) {
            props.put("mail.smtp.auth", (Object)true);
            authenticator = new Authenticator(){
                private PasswordAuthentication pa;
                {
                    this.pa = new PasswordAuthentication(Emailer.this.username, Emailer.this.password);
                }

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return this.pa;
                }
            };
        }
        Session session = Session.getInstance(props, authenticator);
        session.setDebug(this.debug);
        String tmp = IOEssentials.readString(f);
        String[] temp = tmp.split("\n");
        String charset = "UTF-8";
        int i = 0;
        while (i < temp.length) {
            if (temp[i].contains("charset=")) {
                charset = temp[i].replace("charset=", "").replace("\"", "").trim();
                break;
            }
            ++i;
        }
        if (name != null && name.length() > 0) {
            String[] parts = StringEssentials.splitWords(name);
            tmp = tmp.replace("_RECIPIENT-NAME_", name);
            tmp = tmp.replace("_RECIPIENT-FNAME_", parts[0]);
            tmp = tmp.replace("_RECIPIENT-LNAME_", parts[parts.length - 1]);
        }
        MimeMessage message = new MimeMessage(session, name == null || name.length() == 0 ? new FileInputStream(f) : new ByteArrayInputStream(tmp.getBytes(charset)));
        Multipart body = null;
        try {
            body = (Multipart)message.getContent();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.attachments != null && body != null) {
            int i2 = 0;
            while (i2 < this.attachments.length) {
                this.addAttachment(body, this.attachments[i2]);
                ++i2;
            }
            message.setContent(body);
        }
        message = this.prepareToSend(to, subject, message);
        Transport.send(message);
    }

    public void preview(String to, String subject, File f, String name) throws MessagingException, IOException {
        if (f.getName().endsWith(".html") || f.getName().endsWith(".htm")) {
            this.preview(to, subject, this.createHTMLMultiPartFromHTMLString(IOEssentials.readString(f), name), null);
            return;
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", this.host);
        props.put("mail.smtp.port", (Object)this.port);
        switch (this.protocol) {
            case SMTPS: {
                props.put("mail.smtp.ssl.enable", (Object)true);
                break;
            }
            case TLS: {
                props.put("mail.smtp.starttls.enable", (Object)true);
            }
        }
        Authenticator authenticator = null;
        if (this.auth) {
            props.put("mail.smtp.auth", (Object)true);
            authenticator = new Authenticator(){
                private PasswordAuthentication pa;
                {
                    this.pa = new PasswordAuthentication(Emailer.this.username, Emailer.this.password);
                }

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return this.pa;
                }
            };
        }
        Session session = Session.getInstance(props, authenticator);
        session.setDebug(this.debug);
        String tmp = IOEssentials.readString(f);
        String[] temp = tmp.split("\n");
        String charset = "UTF-8";
        int i = 0;
        while (i < temp.length) {
            if (temp[i].contains("charset=")) {
                charset = temp[i].replace("charset=", "").replace("\"", "").trim();
                break;
            }
            ++i;
        }
        if (name != null && name.length() > 0) {
            String[] parts = StringEssentials.splitWords(name);
            tmp = tmp.replace("_RECIPIENT-NAME_", name);
            tmp = tmp.replace("_RECIPIENT-FNAME_", parts[0]);
            tmp = tmp.replace("_RECIPIENT-LNAME_", parts[parts.length - 1]);
        }
        MimeMessage message = new MimeMessage(session, name == null || name.length() == 0 ? new FileInputStream(f) : new ByteArrayInputStream(tmp.getBytes(charset)));
        Multipart body = null;
        try {
            body = (Multipart)message.getContent();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.attachments != null && body != null) {
            int i2 = 0;
            while (i2 < this.attachments.length) {
                this.addAttachment(body, this.attachments[i2]);
                ++i2;
            }
            message.setContent(body);
        }
        message = this.prepareToSend(to, subject, message);
        this.createPreview(message);
    }

    public void send(String to, String subject, MimeMultipart body, String name) throws MessagingException, IOException {
        Properties props = new Properties();
        props.put("mail.smtp.host", this.host);
        props.put("mail.smtp.port", (Object)this.port);
        switch (this.protocol) {
            case SMTPS: {
                props.put("mail.smtp.ssl.enable", (Object)true);
                break;
            }
            case TLS: {
                props.put("mail.smtp.starttls.enable", (Object)true);
            }
        }
        Authenticator authenticator = null;
        if (this.auth) {
            props.put("mail.smtp.auth", (Object)true);
            authenticator = new Authenticator(){
                private PasswordAuthentication pa;
                {
                    this.pa = new PasswordAuthentication(Emailer.this.username, Emailer.this.password);
                }

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return this.pa;
                }
            };
        }
        Session session = Session.getInstance(props, authenticator);
        session.setDebug(this.debug);
        MimeMessage message = new MimeMessage(session);
        if (name != null && name.length() != 0) {
            int X = body.getCount();
            int i = 0;
            while (i < X) {
                BodyPart mbp = body.getBodyPart(i);
                body.removeBodyPart(i);
                boolean html = false;
                boolean plain = false;
                if (mbp.isMimeType("text/html")) {
                    html = true;
                } else if (mbp.isMimeType("text/plain")) {
                    plain = true;
                }
                if (html || plain) {
                    Object content = mbp.getContent();
                    String str = "";
                    if (content instanceof String) {
                        str = (String)content;
                    } else if (content instanceof InputStream) {
                        str = IOEssentials.readString((InputStream)content);
                    }
                    if (name != null && name.length() > 0) {
                        String[] parts = StringEssentials.splitWords(name);
                        str = str.replace("_RECIPIENT-NAME_", name);
                        str = str.replace("_RECIPIENT-FNAME_", parts[0]);
                        str = str.replace("_RECIPIENT-LNAME_", parts[parts.length - 1]);
                    }
                    mbp.setContent(str, html ? "text/html; charset=UTF-8" : "text/plain; charset=UTF-8");
                }
                body.addBodyPart(mbp);
                ++i;
            }
        }
        if (this.attachments != null) {
            int i = 0;
            while (i < this.attachments.length) {
                this.addAttachment(body, this.attachments[i]);
                ++i;
            }
        }
        message.setContent(body, "text/html; charset=UTF-8");
        message = this.prepareToSend(to, subject, message);
        Transport.send(message);
    }

    public void preview(String to, String subject, MimeMultipart body, String name) throws MessagingException, IOException {
        Properties props = new Properties();
        props.put("mail.smtp.host", this.host);
        props.put("mail.smtp.port", (Object)this.port);
        switch (this.protocol) {
            case SMTPS: {
                props.put("mail.smtp.ssl.enable", (Object)true);
                break;
            }
            case TLS: {
                props.put("mail.smtp.starttls.enable", (Object)true);
            }
        }
        Authenticator authenticator = null;
        if (this.auth) {
            props.put("mail.smtp.auth", (Object)true);
            authenticator = new Authenticator(){
                private PasswordAuthentication pa;
                {
                    this.pa = new PasswordAuthentication(Emailer.this.username, Emailer.this.password);
                }

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return this.pa;
                }
            };
        }
        Session session = Session.getInstance(props, authenticator);
        session.setDebug(this.debug);
        MimeMessage message = new MimeMessage(session);
        if (name != null && name.length() != 0) {
            int X = body.getCount();
            int i = 0;
            while (i < X) {
                BodyPart mbp = body.getBodyPart(i);
                body.removeBodyPart(i);
                boolean html = false;
                boolean plain = false;
                if (mbp.isMimeType("text/html")) {
                    html = true;
                } else if (mbp.isMimeType("text/plain")) {
                    plain = true;
                }
                if (html || plain) {
                    Object content = mbp.getContent();
                    String str = "";
                    if (content instanceof String) {
                        str = (String)content;
                    } else if (content instanceof InputStream) {
                        str = IOEssentials.readString((InputStream)content);
                    }
                    if (name != null && name.length() > 0) {
                        String[] parts = StringEssentials.splitWords(name);
                        str = str.replace("_RECIPIENT-NAME_", name);
                        str = str.replace("_RECIPIENT-FNAME_", parts[0]);
                        str = str.replace("_RECIPIENT-LNAME_", parts[parts.length - 1]);
                    }
                    mbp.setContent(str, html ? "text/html; charset=UTF-8" : "text/html; charset=UTF-8");
                }
                body.addBodyPart(mbp);
                ++i;
            }
        }
        if (this.attachments != null) {
            int i = 0;
            while (i < this.attachments.length) {
                this.addAttachment(body, this.attachments[i]);
                ++i;
            }
        }
        message.setContent(body, "text/html; charset=UTF-8");
        message = this.prepareToSend(to, subject, message);
        this.createPreview(message);
    }

    private MimeMessage prepareToSend(String to, String subject, MimeMessage message) throws MessagingException, UnsupportedEncodingException {
        if (this.senderName == null) {
            message.setFrom(new InternetAddress(this.from));
        } else {
            message.setFrom(new InternetAddress(this.from, this.senderName));
        }
        Address[] address = new InternetAddress[]{new InternetAddress(to)};
        message.setRecipients(Message.RecipientType.TO, address);
        message.setSubject(subject);
        message.setSentDate(new Date());
        if (this.sendACopy) {
            message.setRecipient(Message.RecipientType.CC, new InternetAddress(this.from));
        }
        if (this.requestFeedback) {
            message.addHeader("Return-Receipt-To", this.from);
            message.addHeader("Disposition-Notification-To", this.from);
        }
        message.saveChanges();
        return message;
    }

    private void createPreview(MimeMessage message) throws IOException, MessagingException {
        File f = new File("MassMailer_Preview.eml");
        FileOutputStream fos = new FileOutputStream(f);
        message.writeTo(fos);
        fos.flush();
        fos.close();
        fos = null;
        Desktop.getDesktop().open(f);
    }

    private MimeMultipart createHTMLMultiPartFromHTMLString(String htmlString, String name) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart("related");
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        if (name != null && name.length() > 0) {
            String[] parts = StringEssentials.splitWords(name);
            htmlString = htmlString.replace("_RECIPIENT-NAME_", name);
            htmlString = htmlString.replace("_RECIPIENT-FNAME_", parts[0]);
            htmlString = htmlString.replace("_RECIPIENT-LNAME_", parts[parts.length - 1]);
        }
        if (!htmlString.contains("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />")) {
            int index = htmlString.indexOf("<head>");
            if (index > -1) {
                htmlString = String.valueOf(new String(htmlString.substring(0, index + 6))) + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />" + new String(htmlString.substring(index + 6, htmlString.length()));
            } else {
                index = htmlString.indexOf("</title>");
                if (index > -1) {
                    htmlString = String.valueOf(new String(htmlString.substring(0, index + 8))) + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />" + new String(htmlString.substring(index + 8, htmlString.length()));
                } else {
                    index = htmlString.indexOf("<html>");
                    if (index > -1) {
                        htmlString = String.valueOf(new String(htmlString.substring(0, index + 7))) + "<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" /></head>" + new String(htmlString.substring(index + 7, htmlString.length()));
                    }
                }
            }
        }
        messageBodyPart.setContent(htmlString, "text/html; charset=UTF-8");
        messageBodyPart.setHeader("Content-Type", "text/html; charset=UTF-8");
        multipart.addBodyPart(messageBodyPart);
        return multipart;
    }

    public static enum Protocol {
        SMTP,
        SMTPS,
        TLS;

    }
}

