/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.yachtregisterer;

import info.thereisonlywe.core.essentials.DataEssentials;
import info.thereisonlywe.core.essentials.IOEssentials;
import info.thereisonlywe.core.essentials.StringEssentials;
import info.thereisonlywe.core.toolkit.AESEncryptor;
import info.thereisonlywe.emailer.Emailer;
import info.thereisonlywe.yachtregisterer.MainUI;
import info.thereisonlywe.yachtregisterer.YachtDetails;
import info.thereisonlywe.yachtregisterer.YachtDetailsE;
import java.io.File;
import java.io.IOException;
import java.net.NetworkInterface;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class Values {
    protected static final File file = new File("Yacht Registerer.db");
    protected static boolean isAuthenticated = false;
    protected static boolean isNewInstallation = false;
    protected static boolean isManager = false;
    protected static boolean isOnHold = false;
    protected static char[] PW;
    protected static char[] masterPW;
    protected static char[] doc;
    protected static char[] cs;
    protected static final String tday;
    protected static boolean backupSession;
    protected static int nextFileNumber;
    protected static ArrayList<YachtDetailsE> yachts;
    protected static ArrayList<Integer> filteredIDs;
    protected static ArrayList<Integer> openIDs;
    protected static Calendar calendar;
    protected static boolean privilegeAdd;
    protected static boolean privilegeRemove;
    protected static boolean privilegeEdit;
    protected static boolean privilegePrintYacht;
    protected static boolean privilegePrintSearch;
    protected static boolean privilegeSearch;
    protected static boolean privilegeSearchEnding;
    protected static boolean privilegeShareYacht;
    protected static boolean privilegeShareSearch;
    protected static String emailNotificationSubject;
    protected static String emailNotificationMessage;
    protected static String emailList;
    protected static String emailSenderName;
    protected static boolean emailNotificationSendToOwner;
    protected static boolean emailNotificationSendToIlgili;
    protected static boolean emailNotificationSendToCaptain;
    protected static boolean alertCompany;
    protected static boolean alertCustomer;
    protected static boolean autoSave;
    protected static long lastCheck;
    protected static boolean sync;
    protected static int syncInterval;
    protected static int sorting;
    protected static Emailer emailer;
    protected static boolean onLAN;
    protected static boolean useDefaultSMTP;
    protected static String mailHost;
    protected static String mailPort;
    protected static boolean mailSSL;
    protected static String mailFrom;
    protected static String mailUsername;
    protected static char[] mailPW;
    protected static boolean isDemo;
    protected static boolean stopSearch;
    protected static boolean isSearching;
    protected static int searchThreads;

    static {
        backupSession = true;
        nextFileNumber = 1;
        yachts = new ArrayList();
        filteredIDs = new ArrayList();
        openIDs = new ArrayList();
        privilegeAdd = true;
        privilegeRemove = true;
        privilegeEdit = true;
        privilegePrintYacht = true;
        privilegePrintSearch = true;
        privilegeSearch = true;
        privilegeSearchEnding = true;
        privilegeShareYacht = true;
        privilegeShareSearch = true;
        emailNotificationSubject = "Yat\u0131n\u0131z hakk\u0131nda bildiri";
        emailNotificationMessage = "Say\u0131n _RECIPIENT-NAME_,\n\nYat\u0131n\u0131za ait belgenin s\u00fcresi dolmak \u00fczeredir. Bilginize!\n\nYenileme i\u00e7in m\u00fcsait bir vaktinizde bizle irtibata ge\u00e7iniz.\n\n\n(Otomatik g\u00f6nderilmi\u015f bir bilgilendirme mesaj\u0131d\u0131r. L\u00fctfen bu mesaj\u0131 cevaplamay\u0131n\u0131z.)";
        emailList = "ornek@sirketim.com, ornek2@sirketim.com";
        emailSenderName = "Yat Acentas\u0131";
        emailNotificationSendToOwner = true;
        emailNotificationSendToIlgili = true;
        emailNotificationSendToCaptain = true;
        alertCompany = false;
        alertCustomer = false;
        autoSave = true;
        lastCheck = 0L;
        sync = false;
        syncInterval = 5;
        sorting = 0;
        emailer = new Emailer();
        onLAN = false;
        useDefaultSMTP = true;
        mailHost = "smtp.ornek.com";
        mailPort = "587";
        mailSSL = false;
        mailFrom = "sirket@ornek.com";
        mailUsername = "sirket@ornek.com";
        mailPW = Values.encryptor("sifre", true);
        isDemo = false;
        stopSearch = false;
        isSearching = false;
        searchThreads = 0;
        calendar = Calendar.getInstance();
        tday = String.valueOf(calendar.get(1)) + "-" + StringEssentials.addPaddingToNumber(calendar.get(2) + 1, 2) + "-" + StringEssentials.addPaddingToNumber(calendar.get(5), 2);
        try {
            emailNotificationMessage = new String(Files.readAllBytes(Paths.get(Values.class.getResource("/drafts/CustomerNotification.txt").toURI())), "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void importSettings(String data) {
        String[] t = data.split("#:#");
        if (t.length > 0) {
            nextFileNumber = Integer.parseInt(t[0]);
        }
        if (t.length > 1) {
            backupSession = Boolean.parseBoolean(t[1]);
        }
        if (t.length > 2) {
            privilegeAdd = Boolean.parseBoolean(t[2]);
        }
        if (t.length > 3) {
            privilegeRemove = Boolean.parseBoolean(t[3]);
        }
        if (t.length > 4) {
            privilegeEdit = Boolean.parseBoolean(t[4]);
        }
        if (t.length > 5) {
            privilegePrintYacht = Boolean.parseBoolean(t[5]);
        }
        if (t.length > 6) {
            privilegeSearch = Boolean.parseBoolean(t[6]);
        }
        if (t.length > 7) {
            privilegePrintSearch = Boolean.parseBoolean(t[7]);
        }
        if (t.length > 8) {
            privilegeShareSearch = Boolean.parseBoolean(t[8]);
        }
        if (t.length > 9) {
            privilegeSearchEnding = Boolean.parseBoolean(t[9]);
        }
        if (t.length > 10) {
            privilegeShareYacht = Boolean.parseBoolean(t[10]);
        }
        if (t.length > 11) {
            emailList = t[11];
        }
        if (t.length > 12) {
            emailSenderName = t[12];
        }
        if (t.length > 13) {
            emailNotificationSubject = t[13];
        }
        if (t.length > 14) {
            emailNotificationMessage = t[14];
        }
        if (t.length > 15) {
            alertCustomer = Boolean.parseBoolean(t[15]);
        }
        if (t.length > 16) {
            alertCompany = Boolean.parseBoolean(t[16]);
        }
        if (t.length > 17) {
            lastCheck = Long.parseLong(t[17]);
        }
        if (t.length > 18) {
            emailNotificationSendToOwner = Boolean.parseBoolean(t[18]);
        }
        if (t.length > 19) {
            emailNotificationSendToIlgili = Boolean.parseBoolean(t[19]);
        }
        if (t.length > 20) {
            emailNotificationSendToCaptain = Boolean.parseBoolean(t[20]);
        }
        if (t.length > 21) {
            autoSave = Boolean.parseBoolean(t[21]);
        }
        if (t.length > 22) {
            sync = Boolean.parseBoolean(t[22]);
        }
        if (t.length > 23) {
            sorting = Integer.parseInt(t[23]);
        }
        if (t.length > 24) {
            onLAN = Boolean.parseBoolean(t[24]);
        }
        if (t.length > 25) {
            useDefaultSMTP = Boolean.parseBoolean(t[25]);
        }
        if (t.length > 26) {
            mailSSL = Boolean.parseBoolean(t[26]);
        }
        if (t.length > 27) {
            mailHost = t[27];
        }
        if (t.length > 28) {
            mailPort = t[28];
        }
        if (t.length > 29) {
            mailFrom = t[29];
        }
        if (t.length > 30) {
            mailUsername = t[30];
        }
        if (t.length > 31) {
            mailPW = t[31].toCharArray();
        }
        emailer.setAuthorization(true);
        emailer.setSendACopy(false);
        Values.setSMTP();
    }

    protected static void setSMTP() {
        if (useDefaultSMTP) {
            emailer.setRequestFeedback(false);
            emailer.setHost("smtp.gmail.com");
            emailer.setPassword(String.valueOf(Values.encryptor("6GN8fTr2l/rmRccHjaQzwg==", false)));
            emailer.setPort(465);
            emailer.setProtocol(Emailer.Protocol.SMTPS);
            emailer.setFrom("yachtregisterer@gmail.com");
            emailer.setUsername("yachtregisterer@gmail.com");
        } else {
            emailer.setRequestFeedback(true);
            emailer.setHost(mailHost);
            emailer.setPassword(String.valueOf(Values.encryptor(new String(mailPW), false)));
            emailer.setPort(Integer.valueOf(mailPort));
            emailer.setProtocol(mailSSL ? Emailer.Protocol.SMTPS : Emailer.Protocol.SMTP);
            emailer.setFrom(mailFrom);
            emailer.setUsername(mailUsername);
        }
        emailer.setSenderName(emailSenderName);
    }

    protected static void importYachts(String data) {
        if (data == null || data.length() < 5) {
            return;
        }
        String[] t = data.split("#:#");
        if (t != null && t.length > 0) {
            yachts = new ArrayList();
        }
        int i = 0;
        while (i < t.length) {
            YachtDetails temp = YachtDetails.fromString(t[i]);
            if (temp != null) {
                yachts.add(new YachtDetailsE(temp));
            }
            ++i;
        }
        syncInterval = yachts.size() > 10000 ? 0 : (yachts.size() > 5000 ? 1 : (yachts.size() > 1000 ? 2 : (yachts.size() > 500 ? 3 : (yachts.size() > 100 ? 4 : (yachts.size() > 50 ? 5 : 6)))));
    }

    protected static String exportYachts() {
        if (yachts.size() == 0) {
            return " ";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < yachts.size()) {
            sb.append(yachts.get(i).toString());
            if (i + 1 < yachts.size()) {
                sb.append("#:#");
            }
            ++i;
        }
        return sb.toString();
    }

    protected static void addYacht(YachtDetails y) {
        int index = yachts.indexOf(y);
        if (index == -1) {
            yachts.add(new YachtDetailsE(y));
            Values.sortYachts();
        } else {
            yachts.set(index, new YachtDetailsE(y));
        }
        ++nextFileNumber;
        MainUI.refreshTable();
    }

    protected static void removeYacht(YachtDetails y) {
        int index = yachts.indexOf(y);
        if (index != -1) {
            yachts.remove(y);
            Values.sortYachts();
            MainUI.refreshTable();
        }
    }

    protected static void save() {
        if (isDemo) {
            return;
        }
        try {
            if (isNewInstallation) {
                file.createNewFile();
                long l = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime().toMillis();
                doc = Values.encryptor(String.valueOf(l), true);
                StringBuilder sb = new StringBuilder();
                Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                while (nis.hasMoreElements()) {
                    NetworkInterface ni = nis.nextElement();
                    sb.append(ni.getDisplayName());
                    sb.append("#:#");
                }
                cs = Values.encryptor(String.valueOf(sb.toString()), true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Values.takeBackup(file);
    }

    protected static String getToday() {
        return String.valueOf(StringEssentials.addPaddingToNumber(calendar.get(5), 2)) + "." + StringEssentials.addPaddingToNumber(calendar.get(2) + 1, 2) + "." + calendar.get(1);
    }

    protected static File getBackupFile() {
        File f = new File("backup" + File.separator + "Yacht Registerer " + tday + "-" + StringEssentials.addPaddingToNumber(calendar.get(11), 2) + "." + StringEssentials.addPaddingToNumber(calendar.get(12), 2) + ".db");
        try {
            f.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (f.exists()) {
            return f;
        }
        return null;
    }

    protected static void takeBackup(File f) {
        if (f == null || isDemo) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(f.exists() ? Values.encryptor(new String(doc), false) : Values.encryptor(String.valueOf(Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime().toMillis()), false));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sb.append(")|(");
        sb.append(Values.encryptor(new String(cs), false));
        sb.append(")|(");
        sb.append(Values.encryptor(new String(masterPW), false));
        sb.append(")|(");
        sb.append(nextFileNumber);
        sb.append("#:#");
        sb.append(backupSession);
        sb.append("#:#");
        sb.append(privilegeAdd);
        sb.append("#:#");
        sb.append(privilegeRemove);
        sb.append("#:#");
        sb.append(privilegeEdit);
        sb.append("#:#");
        sb.append(privilegePrintYacht);
        sb.append("#:#");
        sb.append(privilegeSearch);
        sb.append("#:#");
        sb.append(privilegePrintSearch);
        sb.append("#:#");
        sb.append(privilegeShareSearch);
        sb.append("#:#");
        sb.append(privilegeSearchEnding);
        sb.append("#:#");
        sb.append(privilegeShareYacht);
        sb.append("#:#");
        sb.append(emailList);
        sb.append("#:#");
        sb.append(emailSenderName);
        sb.append("#:#");
        sb.append(emailNotificationSubject);
        sb.append("#:#");
        sb.append(emailNotificationMessage);
        sb.append("#:#");
        sb.append(alertCustomer);
        sb.append("#:#");
        sb.append(alertCompany);
        sb.append("#:#");
        sb.append(lastCheck);
        sb.append("#:#");
        sb.append(emailNotificationSendToOwner);
        sb.append("#:#");
        sb.append(emailNotificationSendToIlgili);
        sb.append("#:#");
        sb.append(emailNotificationSendToCaptain);
        sb.append("#:#");
        sb.append(autoSave);
        sb.append("#:#");
        sb.append(sync);
        sb.append("#:#");
        sb.append(sorting);
        sb.append("#:#");
        sb.append(onLAN);
        sb.append("#:#");
        sb.append(useDefaultSMTP);
        sb.append("#:#");
        sb.append(mailSSL);
        sb.append("#:#");
        sb.append(mailHost);
        sb.append("#:#");
        sb.append(mailPort);
        sb.append("#:#");
        sb.append(mailFrom);
        sb.append("#:#");
        sb.append(mailUsername);
        sb.append("#:#");
        sb.append(String.valueOf(mailPW));
        sb.append(")|(");
        sb.append(Values.exportYachts());
        IOEssentials.write(new String(Values.encryptor(sb.toString(), Values.encryptor(new String(PW), false), true)), f);
    }

    protected static void sortYachts() {
        Collections.sort(yachts);
    }

    protected static char[] encryptor(String st, char[] pw, boolean en) {
        char[] result = null;
        int len = pw.length;
        try {
            if (en) {
                result = AESEncryptor.encode(new byte[]{(byte)(-1 * (len % 3)), (byte)(-1 * (len % 4)), (byte)(-1 * (len % 9)), (byte)(-1 * (len % 128)), (byte)(len % 125), (byte)(len % 9), (byte)(len % 6), (byte)(len % 3)}, Character.codePointAt(pw, len - 1) + len + Character.codePointAt(pw, 0), pw, st.getBytes("UTF-8"));
            } else {
                try {
                    result = DataEssentials.toChars(AESEncryptor.decode(new byte[]{(byte)(-1 * (len % 3)), (byte)(-1 * (len % 4)), (byte)(-1 * (len % 9)), (byte)(-1 * (len % 128)), (byte)(len % 125), (byte)(len % 9), (byte)(len % 6), (byte)(len % 3)}, Character.codePointAt(pw, len - 1) + len + Character.codePointAt(pw, 0), pw, st), "UTF-8");
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected static char[] encryptor(String st, boolean en) {
        return Values.encryptor(st, new char[]{'i', 'n', 'f', 'o', '.', 't', 'h', 'e', 'r', 'i', 's', 'o', 'n', 'l', 'y', 'w', 'e', '.', 'y', 'a', 'c', 'h', 't', 'f', 'i', 'n', 'd', 'e', 'r'}, en);
    }

    protected static String[][] getTableData() {
        String[][] result = new String[MainUI.tableModel.getRowCount()][MainUI.tableModel.getColumnCount()];
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < MainUI.tableModel.getColumnCount()) {
                result[i][j] = (String)MainUI.tableModel.getValueAt(i, j);
                ++j;
            }
            ++i;
        }
        return result;
    }

    protected MimeMultipart getMultipart(String htmlText) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart("related");
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent("<html>" + htmlText + "</html>", "text/html");
        messageBodyPart.setHeader("Content-Type", "text/html");
        multipart.addBodyPart(messageBodyPart);
        return multipart;
    }

    protected static void sync() {
        if (file.exists()) {
            char[] txt = Values.encryptor(new String(PW), false);
            char[] s = Values.encryptor(IOEssentials.readString(file), txt, false);
            if (s != null && s.length > 0) {
                long l = 0L;
                try {
                    l = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime().toMillis();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                String[] k = new String(s).split(Pattern.quote(")|("));
                if (l != Long.parseLong(k[0])) {
                    return;
                }
                masterPW = Values.encryptor(k[2], true);
                k[2] = null;
                cs = Values.encryptor(k[1], true);
                Values.importSettings(k[3]);
                k[3] = null;
                Values.importYachts(k[4]);
                k[4] = null;
                Values.save();
            }
        }
    }
}

