/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.cosmology;

import info.thereisonlywe.core.essentials.LanguageEssentials;
import info.thereisonlywe.core.essentials.LocaleEssentials;
import info.thereisonlywe.core.objects.NumberRange;

public enum ZodiacMansion {
    _1(new NumberRange(0.0, 12.857142857142758)),
    _2(new NumberRange(12.857142857142858, 25.714285714285616)),
    _3(new NumberRange(25.714285714285715, 38.57142857142847)),
    _4(new NumberRange(38.57142857142857, 51.42857142857133)),
    _5(new NumberRange(51.42857142857143, 64.28571428571419)),
    _6(new NumberRange(64.28571428571429, 77.14285714285704)),
    _7(new NumberRange(77.14285714285714, 89.9999999999999)),
    _8(new NumberRange(90.0, 102.85714285714276)),
    _9(new NumberRange(102.85714285714286, 115.71428571428562)),
    _10(new NumberRange(115.71428571428572, 128.57142857142847)),
    _11(new NumberRange(128.57142857142858, 141.42857142857133)),
    _12(new NumberRange(141.42857142857144, 154.28571428571416)),
    _13(new NumberRange(154.28571428571428, 167.14285714285703)),
    _14(new NumberRange(167.14285714285714, 179.9999999999999)),
    _15(new NumberRange(180.0, 192.85714285714275)),
    _16(new NumberRange(192.85714285714286, 205.7142857142856)),
    _17(new NumberRange(205.71428571428572, 218.57142857142847)),
    _18(new NumberRange(218.57142857142858, 231.42857142857133)),
    _19(new NumberRange(231.42857142857144, 244.2857142857142)),
    _20(new NumberRange(244.2857142857143, 257.14285714285705)),
    _21(new NumberRange(257.14285714285717, 269.9999999999999)),
    _22(new NumberRange(270.0, 282.8571428571428)),
    _23(new NumberRange(282.8571428571429, 295.7142857142856)),
    _24(new NumberRange(295.7142857142857, 308.57142857142844)),
    _25(new NumberRange(308.57142857142856, 321.42857142857133)),
    _26(new NumberRange(321.42857142857144, 334.28571428571416)),
    _27(new NumberRange(334.2857142857143, 347.14285714285705)),
    _28(new NumberRange(347.14285714285717, 359.9999999999999));

    public final NumberRange degreeSpan;
    public static final double DEGREE_SPAN_PER_MANSION = 12.857142857142758;

    private ZodiacMansion(NumberRange range) {
        this.degreeSpan = range;
    }

    public String getName(String lang) {
        int number = Integer.parseInt(this.name().replace("_", ""));
        if (lang.equals("tr")) {
            return String.valueOf(number) + ". Menzil";
        }
        return String.valueOf(number) + LanguageEssentials.English.getNumberOrderSuffix(number) + " Mansion";
    }

    public String toString() {
        return this.getName(LocaleEssentials.LANGUAGE_DEFAULT);
    }
}

