/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.essentials;

import info.thereisonlywe.core.cosmology.Planet;
import info.thereisonlywe.core.cosmology.ZodiacAspect;
import info.thereisonlywe.core.cosmology.ZodiacMansion;
import info.thereisonlywe.core.cosmology.ZodiacSign;
import info.thereisonlywe.core.essentials.StringEssentials;
import info.thereisonlywe.core.essentials.SystemEssentials;
import info.thereisonlywe.core.ontology.DivineName;
import info.thereisonlywe.core.ontology.Element;
import info.thereisonlywe.core.ontology.Gender;
import info.thereisonlywe.core.ontology.Letter;
import info.thereisonlywe.core.ontology.Manifestation;
import info.thereisonlywe.core.ontology.Modality;
import info.thereisonlywe.core.ontology.Temperament;
import info.thereisonlywe.core.search.SearchEngine;
import info.thereisonlywe.core.search.SearchModifier;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.xml.sax.InputSource;

public class DataEssentials {
    public static byte[] toBytes(char[] chars, String charsetName) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = Charset.forName(charsetName).encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(charBuffer.array(), '\u0000');
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }

    public static char[] toChars(byte[] data, String charsetname) {
        CharsetDecoder cd = ((Charset)Charset.availableCharsets().get(charsetname)).newDecoder();
        CharBuffer buffer = null;
        try {
            buffer = cd.decode(ByteBuffer.wrap(data));
            return buffer.array();
        }
        catch (CharacterCodingException characterCodingException) {
            return null;
        }
    }

    public static <T> boolean contains(T[] a, Object o) {
        if (a == null) {
            return false;
        }
        T[] TArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            if (element.equals(o)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> Set<T> getDifference(Set<T> a, Set<T> b) {
        TreeSet<T> e = new TreeSet<T>(a);
        e.removeAll(b);
        return e;
    }

    public static <T> List<T> getIntersection(List<T> l1, List<T> l2) {
        l1.retainAll(l2);
        return l1;
    }

    public static <T> Set<T> getIntersection(Set<T> a, Set<T> b) {
        TreeSet<T> d = new TreeSet<T>(a);
        d.retainAll(b);
        return d;
    }

    public static <T> List<T> getNegationOfIntersection(List<T> l1, List<T> l2) {
        List<T> u = DataEssentials.getUnion(l1, l2);
        l1.retainAll(l2);
        u.removeAll(l1);
        return u;
    }

    public static Object getObject(String objectName) {
        return DataEssentials.getObject(objectName, new Class[]{ZodiacSign.class, ZodiacMansion.class, Planet.class, ZodiacAspect.class, DivineName.class, Element.class, Temperament.class, Gender.class, Letter.class, Manifestation.class, Modality.class});
    }

    public static Object getObject(String objectName, Class<?>[] classesToSearchFor) {
        Class<?> element;
        if (classesToSearchFor == null) {
            return null;
        }
        String tmp = objectName;
        tmp = tmp.toUpperCase(Locale.ENGLISH);
        tmp = tmp.replace(" ", "_");
        Class<?>[] classArray = classesToSearchFor;
        int n = classesToSearchFor.length;
        int n2 = 0;
        while (n2 < n) {
            block15: {
                Object o;
                block14: {
                    element = classArray[n2];
                    Field f = null;
                    o = null;
                    try {
                        f = element.getField(tmp);
                        if (f == null) break block14;
                        o = f.get(f.getClass());
                    }
                    catch (SecurityException e) {
                        break block15;
                    }
                    catch (NoSuchFieldException e) {
                        break block15;
                    }
                    catch (IllegalArgumentException e) {
                        break block15;
                    }
                    catch (IllegalAccessException e) {
                        break block15;
                    }
                }
                if (o != null) {
                    return o;
                }
            }
            ++n2;
        }
        classArray = classesToSearchFor;
        n = classesToSearchFor.length;
        n2 = 0;
        while (n2 < n) {
            Field[] fs;
            element = classArray[n2];
            Object o = null;
            Field[] fieldArray = fs = element.getFields();
            int n3 = fs.length;
            int n4 = 0;
            while (n4 < n3) {
                block16: {
                    Field element2 = fieldArray[n4];
                    try {
                        o = element2.get(element2.getClass());
                    }
                    catch (IllegalArgumentException e) {
                        break block16;
                    }
                    catch (IllegalAccessException e) {
                        break block16;
                    }
                    if (o != null && o.toString().equalsIgnoreCase(objectName)) {
                        return o;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static <T> List<T> getReverse(Set<T> a) {
        ArrayList<T> list = new ArrayList<T>(a);
        Collections.reverse(list);
        return list;
    }

    public static <T> List<T> getUnion(List<T> l1, List<T> l2) {
        l1.removeAll(l2);
        l1.addAll(l2);
        return l1;
    }

    public static <T> Set<T> getUnion(Set<T> a, Set<T> b) {
        TreeSet<T> c = new TreeSet<T>(a);
        c.addAll(b);
        return c;
    }

    public static <T> int indexOf(T[] array, T element) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(element)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(String[] array, String element, SearchModifier modifier) {
        int i = 0;
        while (i < array.length) {
            if (SearchEngine.search(array[i], element, modifier)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String[] insertAtBeginning(String[] array, String value) {
        String[] result = new String[array.length + 1];
        result[0] = value;
        int i = 1;
        while (i < result.length) {
            result[i] = array[i - 1];
            ++i;
        }
        return result;
    }

    public static <T> List<T> removeElements(T[] array, int[] elementsInOrder) {
        ArrayList<T> list = new ArrayList<T>(Arrays.asList(array));
        int i = 0;
        while (i < elementsInOrder.length) {
            list.remove(elementsInOrder[i] - i);
            ++i;
        }
        return list;
    }

    public static <T> List<T> removeNullElements(T[] array) {
        ArrayList<T> list = new ArrayList<T>();
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                list.add(array[i]);
            }
            ++i;
        }
        return list;
    }

    public static <T> List<T> removeNullElements(List<T> array) {
        ArrayList<T> list = new ArrayList<T>();
        int i = 0;
        while (i < array.size()) {
            if (array.get(i) != null) {
                list.add(array.get(i));
            }
            ++i;
        }
        return list;
    }

    public static InputSource toInputSource(String str) {
        InputSource s = new InputSource(new StringReader(str));
        return s;
    }

    public static InputStream toInputStream(String str, String encoding) {
        byte[] bytes = null;
        try {
            bytes = str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new ByteArrayInputStream(bytes);
    }

    public static int[] toIntArray(int number) {
        char[] c = String.valueOf(number).toCharArray();
        int[] result = new int[c.length];
        int i = 0;
        while (i < c.length) {
            result[i] = Integer.parseInt(String.valueOf(c[i]));
            ++i;
        }
        return result;
    }

    public static double[] toDoubleArray(double number) {
        char[] c = String.valueOf(number).toCharArray();
        double[] result = new double[c.length];
        int i = 0;
        while (i < c.length) {
            result[i] = Double.parseDouble(String.valueOf(c[i]));
            ++i;
        }
        return result;
    }

    public static int[] toIntArray(Integer[] val) {
        int[] result = new int[val.length];
        System.arraycopy(val, 0, result, 0, result.length);
        return result;
    }

    public static int[] toIntArray(List<Integer> integers) {
        int[] ret = new int[integers.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = integers.get(i);
            ++i;
        }
        return ret;
    }

    public static int[] toIntArray(long number) {
        char[] c = String.valueOf(number).toCharArray();
        int[] result = new int[c.length];
        int i = 0;
        while (i < c.length) {
            result[i] = Integer.parseInt(String.valueOf(c[i]));
            ++i;
        }
        return result;
    }

    public static int[] toIntArray(String[] s) {
        int[] result = new int[s.length];
        int i = 0;
        while (i < s.length) {
            result[i] = Integer.parseInt(s[i]);
            ++i;
        }
        return result;
    }

    public static double[] toDoubleArray(String[] s) {
        double[] result = new double[s.length];
        int i = 0;
        while (i < s.length) {
            result[i] = Double.parseDouble(s[i]);
            ++i;
        }
        return result;
    }

    public static Integer[] toIntegerArray(String[] s) {
        Integer[] result = new Integer[s.length];
        int i = 0;
        while (i < s.length) {
            result[i] = Integer.parseInt(s[i]);
            ++i;
        }
        return result;
    }

    public static List<String> toList(String[] s) {
        return Arrays.asList(s);
    }

    public static long[] toLongArray(long number) {
        char[] c = String.valueOf(number).toCharArray();
        long[] result = new long[c.length];
        int i = 0;
        while (i < c.length) {
            result[i] = Long.parseLong(String.valueOf(c[i]));
            ++i;
        }
        return result;
    }

    public static long[] toLongArray(String[] s) {
        long[] result = new long[s.length];
        int i = 0;
        while (i < s.length) {
            result[i] = Long.parseLong(s[i]);
            ++i;
        }
        return result;
    }

    public static String[] toStringArray(int[] array) {
        String[] res = new String[array.length];
        int i = 0;
        while (i < array.length) {
            res[i] = String.valueOf(array[i]);
            ++i;
        }
        return res;
    }

    public static <T> ArrayList<String> toStringArrayList(ArrayList<T> arrayList) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < arrayList.size()) {
            result.add(String.valueOf(arrayList.get(i)));
            ++i;
        }
        return result;
    }

    public static <T> ArrayList<String> toStringArrayList(List<T> arrayList) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < arrayList.size()) {
            result.add(String.valueOf(arrayList.get(i)));
            ++i;
        }
        return result;
    }

    public static <T> String define(T classInstance) {
        if (classInstance == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Field[] fields = classInstance.getClass().getFields();
        sb.append("-" + classInstance.toString() + "-\n");
        int i = 0;
        while (i < fields.length) {
            if (!fields[i].isEnumConstant()) {
                String name = fields[i].getName();
                sb.append(StringEssentials.camelCaseToStartCase(name));
                sb.append(": ");
                try {
                    sb.append(classInstance.getClass().getField(name).get(classInstance));
                }
                catch (IllegalArgumentException e) {
                    SystemEssentials.Logger.log(Level.WARNING, e);
                }
                catch (SecurityException e) {
                    SystemEssentials.Logger.log(Level.WARNING, e);
                }
                catch (IllegalAccessException e) {
                    SystemEssentials.Logger.log(Level.WARNING, e);
                }
                catch (NoSuchFieldException e) {
                    SystemEssentials.Logger.log(Level.WARNING, e);
                }
                if (i + 1 < fields.length) {
                    sb.append("\n");
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String define(String objectName, Class<?>[] classesToSearchFor) {
        return DataEssentials.define(DataEssentials.getObject(objectName, classesToSearchFor));
    }

    public static String define(String objectName) {
        return DataEssentials.define(DataEssentials.getObject(objectName));
    }
}

