/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.essentials;

import info.thereisonlywe.core.essentials.LanguageEssentials;
import info.thereisonlywe.core.essentials.StringEssentials;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;

public class DateEssentials {
    public static String getDate(Calendar c, String dateSeparator) {
        return String.valueOf(c.get(5)) + dateSeparator + (c.get(2) + 1) + dateSeparator + c.get(1);
    }

    public static boolean isDateInRange(String formattedDateInQuestion, String formattedStartDate, String formattedEndDate, DateFormatOrder dfo) {
        return !DateEssentials.getRelationTo(formattedStartDate, formattedDateInQuestion, dfo).equals(LanguageEssentials.Math.LESS) && !DateEssentials.getRelationTo(formattedEndDate, formattedDateInQuestion, dfo).equals(LanguageEssentials.Math.GREATER);
    }

    public static boolean isDateInRange(Date dateInQuestion, Date startDate, Date endDate) {
        return !DateEssentials.getRelationTo(startDate, dateInQuestion).equals(LanguageEssentials.Math.LESS) && !DateEssentials.getRelationTo(endDate, dateInQuestion).equals(LanguageEssentials.Math.GREATER);
    }

    public static String getRelationTo(String thisFormattedDate, String formattedDateInQuestion, DateFormatOrder dfo) {
        return DateEssentials.getRelationTo(DateEssentials.toDate(thisFormattedDate, dfo), DateEssentials.toDate(formattedDateInQuestion, dfo));
    }

    public static String getRelationTo(Date thisFormattedDate, Date formattedDateInQuestion) {
        if (formattedDateInQuestion.after(thisFormattedDate)) {
            return LanguageEssentials.Math.GREATER;
        }
        if (formattedDateInQuestion.before(thisFormattedDate)) {
            return LanguageEssentials.Math.LESS;
        }
        return LanguageEssentials.Math.EQUALS;
    }

    public static int getDifferenceInDays(Date d1, Date d2) {
        return (int)((d1.getTime() - d2.getTime()) / 86400000L);
    }

    public static Date toDate(String formattedDate, DateFormatOrder dfo) {
        String separator = DateEssentials.getDateSeparator(formattedDate);
        Date d = null;
        try {
            d = dfo == DateFormatOrder.DD_MM_YY ? new SimpleDateFormat("dd" + separator + "MM" + separator + "yyyy").parse(formattedDate) : (dfo == DateFormatOrder.MM_DD_YY ? new SimpleDateFormat("MM" + separator + "dd" + separator + "yyyy").parse(formattedDate) : (dfo == DateFormatOrder.YY_DD_MM ? new SimpleDateFormat("yyyy" + separator + "dd" + separator + "MM").parse(formattedDate) : new SimpleDateFormat("yyyy" + separator + "MM" + separator + "dd").parse(formattedDate)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public static String getFormattedDate(int dayOfMonth, int monthOfYear, int Year, DateFormatOrder dfo, String separator) {
        if (dfo == DateFormatOrder.DD_MM_YY) {
            return String.valueOf(StringEssentials.addPaddingToNumber(dayOfMonth, 2)) + separator + StringEssentials.addPaddingToNumber(monthOfYear, 2) + separator + StringEssentials.addPaddingToNumber(Year, 2);
        }
        if (dfo == DateFormatOrder.MM_DD_YY) {
            return String.valueOf(StringEssentials.addPaddingToNumber(monthOfYear, 2)) + separator + StringEssentials.addPaddingToNumber(dayOfMonth, 2) + separator + StringEssentials.addPaddingToNumber(Year, 2);
        }
        if (dfo == DateFormatOrder.YY_MM_DD) {
            return String.valueOf(StringEssentials.addPaddingToNumber(Year, 2)) + separator + StringEssentials.addPaddingToNumber(monthOfYear, 2) + separator + StringEssentials.addPaddingToNumber(dayOfMonth, 2);
        }
        return String.valueOf(StringEssentials.addPaddingToNumber(Year, 2)) + separator + StringEssentials.addPaddingToNumber(dayOfMonth, 2) + separator + StringEssentials.addPaddingToNumber(monthOfYear, 2);
    }

    public static int getYear(String formattedDate, DateFormatOrder dfo, String separator) {
        String[] vals = formattedDate.split(Pattern.quote(separator));
        return DateEssentials.getYear(vals, dfo);
    }

    public static int getYear(String[] vals, DateFormatOrder dfo) {
        if (dfo == DateFormatOrder.DD_MM_YY || dfo == DateFormatOrder.MM_DD_YY) {
            return Integer.parseInt(vals[2]);
        }
        return Integer.parseInt(vals[0]);
    }

    @Deprecated
    public static int getYear(String formattedDate, DateFormatOrder dfo) {
        return DateEssentials.getYear(formattedDate, dfo, DateEssentials.getDateSeparator(formattedDate));
    }

    public static int getMonth(String formattedDate, DateFormatOrder dfo, String separator) {
        String[] vals = formattedDate.split(Pattern.quote(separator));
        return DateEssentials.getMonth(vals, dfo);
    }

    public static int getMonth(String[] vals, DateFormatOrder dfo) {
        if (dfo == DateFormatOrder.DD_MM_YY || dfo == DateFormatOrder.YY_MM_DD) {
            return Integer.parseInt(vals[1]);
        }
        if (dfo == DateFormatOrder.MM_DD_YY) {
            return Integer.parseInt(vals[0]);
        }
        return Integer.parseInt(vals[2]);
    }

    @Deprecated
    public static int getMonth(String formattedDate, DateFormatOrder dfo) {
        return DateEssentials.getMonth(formattedDate, dfo, DateEssentials.getDateSeparator(formattedDate));
    }

    public static int getDay(String formattedDate, DateFormatOrder dfo, String separator) {
        String[] vals = formattedDate.split(Pattern.quote(separator));
        return DateEssentials.getDay(vals, dfo);
    }

    public static int getDay(String[] vals, DateFormatOrder dfo) {
        if (dfo == DateFormatOrder.DD_MM_YY) {
            return Integer.parseInt(vals[0]);
        }
        if (dfo == DateFormatOrder.MM_DD_YY || dfo == DateFormatOrder.YY_DD_MM) {
            return Integer.parseInt(vals[1]);
        }
        return Integer.parseInt(vals[2]);
    }

    @Deprecated
    public static int getDay(String formattedDate, DateFormatOrder dfo) {
        return DateEssentials.getDay(formattedDate, dfo, DateEssentials.getDateSeparator(formattedDate));
    }

    public static String getDateSeparator(String date) {
        String[] vals = null;
        vals = date.split(Pattern.quote("_"));
        if (vals.length != 3) {
            vals = date.split(Pattern.quote("."));
            if (vals.length != 3) {
                vals = date.split(Pattern.quote("-"));
                if (vals.length != 3) {
                    vals = date.split(Pattern.quote("\u2014"));
                    if (vals.length != 3) {
                        vals = date.split(Pattern.quote("/"));
                        if (vals.length != 3) {
                            vals = date.split(Pattern.quote("\\"));
                            if (vals.length != 3) {
                                return null;
                            }
                            return "\\";
                        }
                        return "/";
                    }
                    return "\u2014";
                }
                return "-";
            }
            return ".";
        }
        return "_";
    }

    public static String correctFormatting(String date, DateFormatOrder dfo) {
        return DateEssentials.correctFormatting(date, dfo, DateEssentials.getDateSeparator(date));
    }

    public static String correctFormatting(String date, DateFormatOrder dfo, String separator) {
        int temp;
        String[] vals = date.split(Pattern.quote(separator));
        if (vals.length != 3) {
            String ds = DateEssentials.getDateSeparator(date);
            if (ds == null) {
                return null;
            }
            vals = date.split(Pattern.quote(ds));
        }
        if (vals.length != 3) {
            return null;
        }
        int i = 0;
        while (i < vals.length) {
            vals[i] = StringEssentials.removeNonNumbers(vals[i]).trim();
            ++i;
        }
        int a = DateEssentials.getDay(vals, dfo);
        int b = DateEssentials.getMonth(vals, dfo);
        int c = DateEssentials.getYear(vals, dfo);
        if (b > 12) {
            temp = b;
            if (a <= 12) {
                b = a;
                a = temp;
            } else {
                b = c;
                c = temp;
            }
        }
        if (a > 31) {
            temp = a;
            if (c <= 31) {
                a = c;
                c = temp;
            } else {
                a = b;
                b = temp;
            }
        }
        return DateEssentials.getFormattedDate(a, b, c, dfo, separator);
    }

    public static enum DateFormatOrder {
        DD_MM_YY,
        MM_DD_YY,
        YY_MM_DD,
        YY_DD_MM;

    }
}

