/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.essentials;

public class LanguageEssentials {
    private static String[] languages = new String[]{"ab;Abkhaz;\u0430\u04a7\u0441\u0443\u0430 \u0431\u044b\u0437\u0448\u04d9\u0430", "af;Afrikaans;Afrikaans", "am;Amharic;Amar\u0259\u00f1\u00f1a", "ar;Arabic;\u0627\u0644\u0639\u0631\u0628\u064a\u0629", "az;Azerbaijani;Azeri", "be;Belorussian;\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f", "bm;Bambara;Bamanankan", "bn;Bengali;Bangla", "bg;Bulgarian;\u0411\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438", "bs;Bosnian;\u0431\u043e\u0441\u0430\u043d\u0441\u043a\u0438 ", "ca;Catalan;Catal\u00e0", "cs;Czech;\u010ce\u0161tina", "cy;Welsh;Cymraeg", "da;Danish;Dansk", "de;German;Deutsch", "dv;Divehi;Divehi", "ee;Ewe;\u0190\u028b\u025b", "el;Greek;\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac", "en;English;English", "es;Spanish;Espa\u00f1ol", "et;Estonian;Eesti", "eu;Basque;Euskera", "fa;Persian;\u0641\u0627\u0631\u0633\u06cc", "ff;Fula;Fulfulde", "fi;Finnish;Suomi", "fr;French;Fran\u00e7ais", "fr-CA;French (Canadian);fran\u00e7ais canadien", "ga;Irish;Gaeilge", "gl;Galician;Galego", "ha;Hausa;Yaren Hausa", "he;Hebrew;\u05e2\u05d1\u05e8\u05d9\u05ea", "hi;Hindi;\u0939\u093f\u0902\u0926\u0940", "hr;Croatian;Hrvatski", "hu;Hungarian;Magyar", "hy;Armenian;\u0540\u0561\u0575\u0565\u0580\u0565\u0576", "id;Indonesian;Bahasa indonesia", "is;Icelandic;\u00cdslenska", "it;Italian;italiano", "ja;Japanese;\u65e5\u672c\u8a9e", "ka;Georgian;\u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8", "kk;Kazakh;\u049a\u0430\u0437\u0430\u049b", "kn;Kannada;\u0c95\u0ca8\u0ccd\u0ca8\u0ca1", "ko;Korean;\ud55c\uad6d\uc5b4", "ku;Kurdish;\u06a9\u0648\u0631\u062f\u06cc", "ky;Kirghiz;\u041a\u044b\u0440\u0433\u044b\u0437", "lt;Lithuanian;Lietuvi\u0161kai", "lu;Luo;Dholuo", "lv;Latvian;Latvie\u0161u", "mk;Macedonian;\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438", "ml;Malayalam;Malay\u0101lam ", "mr;Maranao;Maranao", "ms;Malaysian;Bahasa melayu", "mt;Maltese;Malti", "nl;Dutch;Nederlands", "no;Norwegian;Norsk", "pl;Polish;Polski", "ps;Pashto;\u067e\u069a\u062a\u0648", "pt;Portuguese;Portugu\u00eas", "pt-BR;Portuguese (Brazilian);portugu\u00eas brasileiro", "rn;Kirundi;Kirundi", "ro;Romanian;Rom\u00e2n\u0103", "ru;Russian;Pycc\u0138\u0438\u0439", "rw;Kinyarwanda;Kinyarwanda", "sd;Sindhi;\u0633\u0646\u068c\u064a", "sk;Slovak;Sloven\u010dina", "sl;Slovenian;Sloven\u0161\u010dina", "so;Somali;Af-Soomaali", "sq;Albanian;Shqip", "sr;Serbian;Srpski", "sv;Swedish;Svenska", "sw;Swahili;Kiswahili", "ta;Tamil;Tami\u1e3b", "te;Telugu;\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41", "tg;Tajik;Tajiki", "th;Thai;\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22", "tr;Turkish;T\u00fcrk\u00e7e", "tt;Tatar;\u0442\u0430\u0442\u0430\u0440\u0447\u0430", "ug;Uyghur;Uyghurche", "uk;Ukrainian;\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430", "ur;Urdu;\u0627\u0631\u062f\u0648", "uz;Uzbek;O'zbek", "vi;Vietnamese;Ti\u00ea\u0301ng Vi\u00ea\u0323t", "wo;Wolof;Wolof", "xs;Xhosa;isiXhosa", "yo;Yoruba;Yor\u00f9b\u00e1", "zh;Chinese;\u4e2d\u6587", "zh-Hans;Chinese (Simplified script);\u7b80\u4f53\u4e2d\u6587", "zh-Hant;Chinese (Traditional script);\u7e41\u9ad4\u4e2d\u6587", "zu;Zulu;isiZulu"};

    public static String getEnglishLanguageName(String s) {
        boolean gotCode = s.length() == 2;
        String[] stringArray = languages;
        int n = languages.length;
        int n2 = 0;
        while (n2 < n) {
            String language = stringArray[n2];
            String[] temp = language.split(";");
            if (gotCode && temp[0].equalsIgnoreCase(s)) {
                return temp[1];
            }
            if (temp[2].equalsIgnoreCase(s)) {
                return temp[1];
            }
            ++n2;
        }
        return null;
    }

    public static String getLanguageCode(String s) {
        String[] stringArray = languages;
        int n = languages.length;
        int n2 = 0;
        while (n2 < n) {
            String language = stringArray[n2];
            String[] temp = language.split(";");
            if (temp[1].equalsIgnoreCase(s) || temp[2].equalsIgnoreCase(s)) {
                return temp[0];
            }
            ++n2;
        }
        return null;
    }

    public static String getNativeLanguageName(String s) {
        boolean gotCode = s.length() == 2;
        String[] stringArray = languages;
        int n = languages.length;
        int n2 = 0;
        while (n2 < n) {
            String language = stringArray[n2];
            String[] temp = language.split(";");
            if (gotCode && temp[0].equalsIgnoreCase(s)) {
                return temp[2];
            }
            if (temp[1].equalsIgnoreCase(s)) {
                return temp[2];
            }
            ++n2;
        }
        return null;
    }

    public static boolean isRightToLeftLanguage(String language) {
        String[] list = language.length() == 2 ? new String[]{"ar", "fa", "ur", "he", "yi", "ku", "dv", "sd"} : new String[]{"Arabic", "Persian", "Urdu", "Hebrew", "Yiddish", "\u06a9\u0648\u0631\u062f\u06cc", "Kurdish", "\u05e2\u05d1\u05e8\u05d9\u05ea", "\u0627\u0631\u062f\u0648", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629", "\u0641\u0627\u0631\u0633\u06cc", "\u0633\u0646\u068c\u064a", "Sindhi", "Divehi"};
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (language.equals(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static class Character {
        public static String SHADDA = "\u0651";
        public static String KASRA = "\ufe7a";
        public static String DAMMA = "\ufe78";
        public static String FATHA = "\ufe76";
        public static String SUKUN = "\u0652";
        public static String KASRATAN = "\ufe74";
        public static String DAMMATAN = "\ufe72";
        public static String FATHATAN = "\ufe70";
        public static String MADDAH = "\u0653";
        public static String ALEPH_WAVY_HAMZA_ABOVE = "\u0672";
        public static String ALEPH_WAVY_HAMZA_BELOW = "\u0673";
        public static String ALEPH_HIGH_HAMZA = "\u0675";
        public static String ALEPH_SUPERSCRIPT = "\u0670";
        public static String ALEPH_WASLA = "\u0671";
        public static String ALEPH_HAMZA_ABOVE = "\u0623";
        public static String ALEPH_HAMZA_BELOW = "\u0625";
        public static String ALEPH_MADDA = "\u0622";
        public static String ALEPH_WTF = "\u0623\u0652";
        public static String ALEPH = "\u0627";
        public static String HAMZA_ABOVE = "\u0654";
        public static String HAMZA_BELOW = "\u0655";
        public static String HAMZA = "\u0621";
        public static final String COMPULSORY_PAUSE_QURAN_PAUSE_MARK = "\u06d8";
        public static final String IMPERMISSIBLE_PAUSE_QURAN_PAUSE_MARK = "\u06d9";
        public static final String PERMISSIBLE_PAUSE_QURAN_PAUSE_MARK = "\u06da";
        public static final String UNPREFERABLE_PAUSE_QURAN_PAUSE_MARK = "\u06d6";
        public static final String PREFERABLE_PAUSE_QURAN_PAUSE_MARK = "\u06d7";
        public static final String INTERCHANGEABLE_PAUSE_QURAN_PAUSE_MARK = "\u06db";
        public static final String DOT_DECIMAL = ".";
        public static final String UNDERSCORE = "_";
        public static final String DASH = "\u2014";
        public static final String SCORE_MINUS = "-";
        public static final String SLASH = "/";
        public static final String BACKSLASH = "\\";

        public static boolean isDamma(char c) {
            return c == DAMMA.charAt(0);
        }

        public static boolean isDammatan(char c) {
            return c == DAMMATAN.charAt(0);
        }

        public static boolean isDiacriticMark(char c) {
            return Character.isMaddah(c) || Character.isFatha(c) || Character.isKasra(c) || Character.isDamma(c) || Character.isSukun(c) || Character.isShadda(c) || Character.isFathatan(c) || Character.isKasratan(c) || Character.isDammatan(c);
        }

        public static boolean isFatha(char c) {
            return c == FATHA.charAt(0);
        }

        public static boolean isFathatan(char c) {
            return c == FATHATAN.charAt(0);
        }

        public static boolean isKasra(char c) {
            return c == KASRA.charAt(0);
        }

        public static boolean isKasratan(char c) {
            return c == KASRATAN.charAt(0);
        }

        public static boolean isMaddah(char c) {
            return c == MADDAH.charAt(0);
        }

        public static boolean isMoonLetter(char c) {
            return !Character.isSunLetter(c);
        }

        public static boolean isQuranicPauseMark(char c) {
            return c == COMPULSORY_PAUSE_QURAN_PAUSE_MARK.charAt(0) || c == IMPERMISSIBLE_PAUSE_QURAN_PAUSE_MARK.charAt(0) || c == UNPREFERABLE_PAUSE_QURAN_PAUSE_MARK.charAt(0) || c == PREFERABLE_PAUSE_QURAN_PAUSE_MARK.charAt(0) || c == PERMISSIBLE_PAUSE_QURAN_PAUSE_MARK.charAt(0) || c == INTERCHANGEABLE_PAUSE_QURAN_PAUSE_MARK.charAt(0);
        }

        public static boolean isShadda(char c) {
            return c == SHADDA.charAt(0);
        }

        public static boolean isSukun(char c) {
            return c == SUKUN.charAt(0);
        }

        public static boolean isSunLetter(char c) {
            return c == '\ufe95' || c == '\ufe99' || c == '\ufea9' || c == '\ufeab' || c == '\ufead' || c == '\ufeaf' || c == '\ufeb1' || c == '\ufeb5' || c == '\ufeb9' || c == '\ufebd' || c == '\ufec1' || c == '\ufec5' || c == '\ufedd' || c == '\ufee5';
        }

        public static boolean isValid(char c) {
            if (c == ' ') {
                return true;
            }
            return Character.UnicodeBlock.of(c).equals(Character.UnicodeBlock.ARABIC);
        }

        public static boolean isValid(String s) {
            int i = 0;
            while (i < s.length()) {
                if (!Character.isValid(s.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public static boolean containsArabicCharacter(String s) {
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (c != ' ' && Character.isValid(c)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static class English {
        public static String getNumberOrderSuffix(int number) {
            String s = String.valueOf(number);
            if (s.endsWith("1")) {
                return "st";
            }
            if (s.endsWith("2")) {
                return "nd";
            }
            if (s.endsWith("3")) {
                return "rd";
            }
            return "th";
        }

        public static String getNumberOrderSuffix(int number, boolean together) {
            if (together) {
                return String.valueOf(number) + English.getNumberOrderSuffix(number);
            }
            return English.getNumberOrderSuffix(number);
        }

        public static String getPluralForm(String word) {
            if (word.endsWith("s")) {
                return String.valueOf(word) + "'";
            }
            return String.valueOf(word) + "s";
        }
    }

    public static class Logic {
        public static String NOT2 = "\u00ac";
        public static String NOT = "\u02dc";
        public static String AND = "\u2227";
        public static String AND2 = "&";
        public static String OR = "\u2228";
        public static String XOR = "\u2295";
        public static String XOR2 = "\u22bb";
        public static String NAND = "\u22bc";

        public static boolean isConjunctionChar(char c) {
            return c == AND.charAt(0) || c == AND2.charAt(0);
        }

        public static boolean isConjunctionNegationChar(char c) {
            return c == NAND.charAt(0);
        }

        public static boolean isDisjunctionChar(char c) {
            return c == OR.charAt(0);
        }

        public static boolean isExclusiveDisjunctionChar(char c) {
            return c == XOR.charAt(0) || c == XOR2.charAt(0);
        }

        public static boolean isNegationChar(char c) {
            return c == NOT.charAt(0) || c == NOT2.charAt(0);
        }
    }

    public static class Math {
        public static String GREATER = ">";
        public static String GREATER_OR_EQUAL = ">=";
        public static String LESS = "<";
        public static String LESS_OR_EQUAL = "<=";
        public static String EQUALS = "=";
        public static String NOT_EQUAL_TO = "\u2260";
    }

    public static class Turkish {
        public static String getPluralForm(String word) {
            char c1 = word.charAt(word.length() - 1);
            char c2 = word.charAt(word.length() - 2);
            if (Turkish.isVowel(c1)) {
                if (Turkish.isBoldVowel(c1)) {
                    return String.valueOf(word) + "lar";
                }
                return String.valueOf(word) + "ler";
            }
            if (Turkish.isBoldVowel(c2)) {
                return String.valueOf(word) + "lar";
            }
            return String.valueOf(word) + "ler";
        }

        public static boolean isBoldVowel(char c) {
            return c == 'a' || c == '\u0131' || c == 'o' || c == 'u';
        }

        public static boolean isVowel(char c) {
            return c == 'e' || c == 'i' || c == '\u00f6' || c == '\u00fc' || Turkish.isBoldVowel(c);
        }
    }
}

