/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.essentials;

import info.thereisonlywe.core.essentials.StringEssentials;
import info.thereisonlywe.core.essentials.TimeEssentials;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.logging.Level;

public class SystemEssentials {
    public static String getHostname() {
        String hostname = null;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostname;
    }

    public static void collectGarbage() {
        Object obj = new Object();
        WeakReference<Object> ref = new WeakReference<Object>(obj);
        obj = null;
        while (ref.get() != null) {
            System.gc();
        }
    }

    public static boolean isRunningOnAndroid() {
        return System.getProperties().get("java.vm.name") == null || System.getProperties().get("java.vm.name").equals("Dalvik") || System.getProperties().get("java.vm.vendor").equals("The Android Project");
    }

    public static String runCommand(String cmd) {
        try {
            String s;
            StringBuilder result = new StringBuilder("");
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((s = in.readLine()) != null) {
                result.append(s);
            }
            return result.toString();
        }
        catch (IOException ex) {
            Logger.log(Level.WARNING, ex);
            return null;
        }
    }

    public static void sleep(long echoDelay) {
        try {
            Thread.sleep(echoDelay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static class Logger {
        private static String tobewritten = "";

        public static synchronized void flush() {
            String st = tobewritten;
            tobewritten = "";
            Logger.write(String.valueOf(st) + "\n");
        }

        public static synchronized void log(Level a, Exception b) {
            if (a.equals(Level.SEVERE) || a.equals(Level.WARNING)) {
                Logger.writeF(b.getMessage());
            } else {
                Logger.writeI(b.getMessage());
            }
        }

        public static synchronized void log(Level a, String b) {
            if (a.equals(Level.SEVERE) || a.equals(Level.WARNING)) {
                Logger.writeF(b);
            } else {
                Logger.writeI(b);
            }
        }

        private static String getTime() {
            Calendar cal = Calendar.getInstance();
            String time = String.valueOf(TimeEssentials.formatTime(cal.get(11), cal.get(12), cal.get(13))) + " on " + StringEssentials.addPaddingToNumber(String.valueOf(cal.get(5)), 2) + "." + StringEssentials.addPaddingToNumber(String.valueOf(cal.get(2) + 1), 2) + "." + cal.get(1);
            return time;
        }

        private static void write(String st) {
            try {
                FileWriter fstream = new FileWriter("log.txt", true);
                BufferedWriter out = new BufferedWriter(fstream);
                String stx = String.valueOf(tobewritten) + st;
                out.write(stx);
                tobewritten = "";
                out.flush();
                out.close();
            }
            catch (Exception e) {
                tobewritten = String.valueOf(tobewritten) + st + "\n";
            }
        }

        private static void writeF(String info) {
            String st = "[E] ";
            st = String.valueOf(st) + info + " IN " + new Throwable().fillInStackTrace().getStackTrace()[2].getMethodName() + " {" + new Throwable().fillInStackTrace().getStackTrace()[2].getLineNumber() + "}, " + new Throwable().fillInStackTrace().getStackTrace()[2].getClassName() + " @ " + Logger.getTime();
            System.err.println(st);
            Logger.write(String.valueOf(st) + "\n");
        }

        private static void writeI(String info) {
            String st = "[I] ";
            st = String.valueOf(st) + info + " @ " + Logger.getTime();
            System.out.println(st);
            Logger.write(String.valueOf(st) + "\n");
        }
    }
}

