/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.objects;

import info.thereisonlywe.core.cosmology.ZodiacDegree;
import info.thereisonlywe.core.objects.NumberRange;
import info.thereisonlywe.core.objects.SequentialRange;

public class ZodiacDegreeRange
implements SequentialRange<ZodiacDegree> {
    public final ZodiacDegree start;
    public final ZodiacDegree end;

    public ZodiacDegreeRange(ZodiacDegree start, ZodiacDegree end) {
        this.start = start;
        this.end = end;
    }

    public ZodiacDegreeRange(Double start, Double end) {
        this.start = new ZodiacDegree(start);
        this.end = new ZodiacDegree(end);
    }

    public ZodiacDegreeRange(NumberRange range) {
        this.start = new ZodiacDegree(range.start);
        this.end = new ZodiacDegree(range.end);
    }

    public String toString() {
        return "[" + this.start + ", " + this.end + "]";
    }

    public Double getRange() {
        Double start = Math.min(this.start.degree, this.end.degree);
        Double end = Math.max(this.start.degree, this.end.degree);
        return end - start;
    }

    @Override
    public boolean isInRange(ZodiacDegree k) {
        Double start = Math.min(this.start.degree, this.end.degree);
        Double end = Math.max(this.start.degree, this.end.degree);
        return k.degree >= start && k.degree <= end;
    }
}

