/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.ontology;

import info.thereisonlywe.core.essentials.StringEssentials;
import info.thereisonlywe.core.ontology.Letter;
import java.security.InvalidParameterException;

public class Word {
    private final String word;

    public Word(char[] chars) {
        this(String.valueOf(chars));
    }

    public Word(Letter[] array) {
        StringBuilder sb = new StringBuilder();
        Letter[] letterArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Letter element = letterArray[n2];
            sb.append(element.toString());
            ++n2;
        }
        this.word = this.normalize(sb.toString());
    }

    public Word(String arabicWord) {
        this.word = this.normalize(arabicWord);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Word other = (Word)obj;
        return !(this.word == null ? other.word != null : !this.word.equals(other.word));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.word == null ? 0 : this.word.hashCode());
        return result;
    }

    public int length() {
        return this.word.length();
    }

    public char charAt(int index) {
        return this.word.charAt(index);
    }

    public Letter letterAt(int index) {
        return Letter.valueOf(this.charAt(index));
    }

    public Letter[] toArray() {
        Letter[] result = new Letter[this.word.length()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.letterAt(i);
            ++i;
        }
        return result;
    }

    public static boolean isWord(String wordCanditate) {
        int i = 0;
        while (i < wordCanditate.length()) {
            boolean b = Letter.isLetter(wordCanditate.charAt(i));
            if (!b) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return this.word;
    }

    private String normalize(String arabicWord) {
        arabicWord = StringEssentials.removeDiacritics(arabicWord);
        arabicWord = arabicWord.replace("\u0627", "\u0621");
        arabicWord = arabicWord.replace("\u0649", "\u064a");
        if (!Word.isWord(arabicWord = arabicWord.replace("\u0629", "\u062a"))) {
            throw new InvalidParameterException("Invalid Word.");
        }
        return arabicWord;
    }
}

