/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.search;

import info.thereisonlywe.core.essentials.LocaleEssentials;
import info.thereisonlywe.core.essentials.StringEssentials;
import info.thereisonlywe.core.search.SearchModifier;
import info.thereisonlywe.core.search.SearchScope;
import java.util.Locale;

public class SearchEngine {
    public static boolean contains(String text, String phrase) {
        return text.contains(phrase);
    }

    public static boolean contains_PhraseEndingWith(String text, String phrase) {
        if (text.contains(String.valueOf(phrase) + " ")) {
            return true;
        }
        return text.length() > phrase.length() ? new String(text.substring(text.length() - phrase.length(), text.length())).equals(phrase) : text.length() == phrase.length() && text.equals(phrase);
    }

    public static boolean contains_PhraseExactly(String text, String phrase) {
        if (text.equals(phrase)) {
            return true;
        }
        if (text.contains(" " + phrase + " ")) {
            return true;
        }
        if (text.contains(" " + phrase) && text.endsWith(phrase)) {
            return true;
        }
        return text.contains(String.valueOf(phrase) + " ") && text.startsWith(phrase);
    }

    public static boolean contains_PhraseStartingWith(String text, String phrase) {
        if (text.contains(" " + phrase)) {
            return true;
        }
        if (text.length() >= phrase.length()) {
            return new String(text.substring(0, phrase.length())).equals(phrase);
        }
        return false;
    }

    public static boolean endsWith(String text, String phrase) {
        return text.endsWith(phrase);
    }

    public static boolean matchesExactly(String text, String phrase) {
        return text.equals(phrase);
    }

    public static boolean search(String text, String phrase, SearchModifier modifier) {
        return SearchEngine.search(text, phrase, modifier, SearchScope.NO_LIMITATIONS, true, null);
    }

    public static boolean search(String text, String phrase, SearchModifier modifier, boolean caseSensitive) {
        return SearchEngine.search(text, phrase, modifier, SearchScope.NO_LIMITATIONS, caseSensitive, null);
    }

    public static boolean search(String text, String phrase, SearchModifier modifier, boolean caseSensitive, Locale locale) {
        return SearchEngine.search(text, phrase, modifier, SearchScope.NO_LIMITATIONS, caseSensitive, locale);
    }

    public static boolean search(String text, String phrase, SearchModifier modifier, SearchScope scope) {
        return SearchEngine.search(text, phrase, modifier, scope, true, null);
    }

    public static boolean search(String text, String phrase, SearchModifier modifier, SearchScope scope, boolean caseSensitive) {
        return SearchEngine.search(text, phrase, modifier, scope, caseSensitive, null);
    }

    public static boolean search(String text, String phrase, SearchModifier modifier, SearchScope scope, boolean caseSensitive, Locale locale) {
        if (scope == SearchScope.ASCII_ONLY) {
            text = StringEssentials.toASCII(text);
            phrase = StringEssentials.toASCII(phrase);
        } else if (scope == SearchScope.NO_ACCENTS_AND_DIACRITICS) {
            text = StringEssentials.removeDiacritics(text);
            phrase = StringEssentials.removeDiacritics(phrase);
        }
        if (!caseSensitive) {
            if (locale == null) {
                locale = LocaleEssentials.LOCALE_DEFAULT;
            }
            text = text.toLowerCase(locale);
            phrase = phrase.toLowerCase(locale);
        }
        if (modifier == SearchModifier.CONTAINS) {
            return SearchEngine.contains(text, phrase);
        }
        if (modifier == SearchModifier.CONTAINS_PHRASE_EXACTLY) {
            return SearchEngine.contains_PhraseExactly(text, phrase);
        }
        if (modifier == SearchModifier.CONTAINS_PHRASE_ENDING_WITH) {
            return SearchEngine.contains_PhraseEndingWith(text, phrase);
        }
        if (modifier == SearchModifier.CONTAINS_PHRASE_STARTING_WITH) {
            return SearchEngine.contains_PhraseStartingWith(text, phrase);
        }
        if (modifier == SearchModifier.STARTS_WITH) {
            return SearchEngine.startsWith(text, phrase);
        }
        if (modifier == SearchModifier.EXACT) {
            return SearchEngine.matchesExactly(text, phrase);
        }
        if (modifier == SearchModifier.ENDS_WITH) {
            return SearchEngine.endsWith(text, phrase);
        }
        return false;
    }

    public static boolean[] search(String[] text, String phrase, SearchModifier modifier) {
        return SearchEngine.search(text, phrase, modifier, SearchScope.NO_LIMITATIONS, true, null);
    }

    public static boolean[] search(String[] text, String phrase, SearchModifier modifier, boolean caseSensitive) {
        return SearchEngine.search(text, phrase, modifier, SearchScope.NO_LIMITATIONS, caseSensitive, null);
    }

    public static boolean[] search(String[] text, String phrase, SearchModifier modifier, boolean caseSensitive, Locale locale) {
        return SearchEngine.search(text, phrase, modifier, SearchScope.NO_LIMITATIONS, caseSensitive, locale);
    }

    public static boolean[] search(String[] text, String phrase, SearchModifier modifier, SearchScope scope) {
        return SearchEngine.search(text, phrase, modifier, scope, true, null);
    }

    public static boolean[] search(String[] text, String phrase, SearchModifier modifier, SearchScope scope, boolean caseSensitive) {
        return SearchEngine.search(text, phrase, modifier, scope, caseSensitive, null);
    }

    public static boolean[] search(String[] text, String phrase, SearchModifier modifier, SearchScope scope, boolean caseSensitive, Locale locale) {
        boolean[] result = new boolean[text.length];
        int i = 0;
        while (i < text.length) {
            result[i] = SearchEngine.search(text[i], phrase, modifier, scope, caseSensitive, locale);
            ++i;
        }
        return result;
    }

    public static boolean startsWith(String text, String phrase) {
        return text.startsWith(phrase);
    }
}

