/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.toolkit;

import info.thereisonlywe.core.essentials.DataEssentials;
import info.thereisonlywe.core.toolkit.Base64Encoder;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESEncryptor {
    private static final String CHARSET_NAME = "UTF-8";
    private static final String RNG_ALGORITHM = "SHA1PRNG";
    private static final String DIGEST_ALGORITHM = "SHA-256";
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";

    public static char[] encode(byte[] salt, int iterations, String password, byte[] text) {
        byte[] rawencryption = null;
        try {
            rawencryption = AESEncryptor.encrypt(salt, iterations, password, text);
        }
        catch (Exception ex) {
            return null;
        }
        char[] res = Base64Encoder.encode(rawencryption);
        rawencryption = null;
        return res;
    }

    public static byte[] decode(byte[] salt, int iterations, String password, String encodedtext) {
        byte[] rawencryption = Base64Encoder.decode(encodedtext);
        byte[] rawdecryption = null;
        try {
            rawdecryption = AESEncryptor.decrypt(salt, iterations, password, rawencryption);
        }
        catch (Exception ex) {
            return null;
        }
        rawencryption = null;
        return rawdecryption;
    }

    public static char[] encode(byte[] salt, int iterations, char[] password, byte[] text) {
        byte[] rawencryption = null;
        try {
            rawencryption = AESEncryptor.encrypt(salt, iterations, password, text);
        }
        catch (Exception ex) {
            return null;
        }
        char[] res = Base64Encoder.encode(rawencryption);
        rawencryption = null;
        return res;
    }

    public static byte[] decode(byte[] salt, int iterations, char[] password, String encodedtext) {
        byte[] rawencryption = Base64Encoder.decode(encodedtext);
        byte[] rawdecryption = null;
        try {
            rawdecryption = AESEncryptor.decrypt(salt, iterations, password, rawencryption);
        }
        catch (Exception ex) {
            return null;
        }
        rawencryption = null;
        return rawdecryption;
    }

    public static byte[] decrypt(byte[] salt, int iterations, char[] password, byte[] ciphertext) throws NoSuchAlgorithmException, UnsupportedEncodingException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        MessageDigest shaDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        byte[] pw = DataEssentials.toBytes(password, CHARSET_NAME);
        Arrays.fill(password, '\u0000');
        int i = 0;
        while (i < iterations) {
            byte[] salted = new byte[pw.length + salt.length];
            System.arraycopy(pw, 0, salted, 0, pw.length);
            System.arraycopy(salt, 0, salted, pw.length, salt.length);
            Arrays.fill(pw, (byte)0);
            shaDigest.reset();
            pw = shaDigest.digest(salted);
            Arrays.fill(salted, (byte)0);
            ++i;
        }
        byte[] key = new byte[16];
        byte[] iv = new byte[16];
        System.arraycopy(pw, 0, key, 0, 16);
        System.arraycopy(pw, 16, iv, 0, 16);
        Arrays.fill(pw, (byte)0);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, (Key)new SecretKeySpec(key, KEY_ALGORITHM), new IvParameterSpec(iv));
        Arrays.fill(key, (byte)0);
        Arrays.fill(iv, (byte)0);
        byte[] res = cipher.doFinal(ciphertext);
        cipher = null;
        return res;
    }

    public static byte[] decrypt(byte[] salt, int iterations, String password, byte[] ciphertext) throws NoSuchAlgorithmException, UnsupportedEncodingException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        MessageDigest shaDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        byte[] pw = password.getBytes(CHARSET_NAME);
        int i = 0;
        while (i < iterations) {
            byte[] salted = new byte[pw.length + salt.length];
            System.arraycopy(pw, 0, salted, 0, pw.length);
            System.arraycopy(salt, 0, salted, pw.length, salt.length);
            Arrays.fill(pw, (byte)0);
            shaDigest.reset();
            pw = shaDigest.digest(salted);
            Arrays.fill(salted, (byte)0);
            ++i;
        }
        byte[] key = new byte[16];
        byte[] iv = new byte[16];
        System.arraycopy(pw, 0, key, 0, 16);
        System.arraycopy(pw, 16, iv, 0, 16);
        Arrays.fill(pw, (byte)0);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, (Key)new SecretKeySpec(key, KEY_ALGORITHM), new IvParameterSpec(iv));
        Arrays.fill(key, (byte)0);
        Arrays.fill(iv, (byte)0);
        byte[] res = cipher.doFinal(ciphertext);
        cipher = null;
        return res;
    }

    public static byte[] encrypt(byte[] salt, int iterations, String password, byte[] cleartext) throws NoSuchAlgorithmException, UnsupportedEncodingException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, InvalidAlgorithmParameterException, BadPaddingException {
        MessageDigest shaDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        byte[] pw = password.getBytes(CHARSET_NAME);
        int i = 0;
        while (i < iterations) {
            byte[] salted = new byte[pw.length + salt.length];
            System.arraycopy(pw, 0, salted, 0, pw.length);
            System.arraycopy(salt, 0, salted, pw.length, salt.length);
            Arrays.fill(pw, (byte)0);
            shaDigest.reset();
            pw = shaDigest.digest(salted);
            Arrays.fill(salted, (byte)0);
            ++i;
        }
        byte[] key = new byte[16];
        byte[] iv = new byte[16];
        System.arraycopy(pw, 0, key, 0, 16);
        System.arraycopy(pw, 16, iv, 0, 16);
        Arrays.fill(pw, (byte)0);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, (Key)new SecretKeySpec(key, KEY_ALGORITHM), new IvParameterSpec(iv));
        Arrays.fill(key, (byte)0);
        Arrays.fill(iv, (byte)0);
        byte[] res = cipher.doFinal(cleartext);
        cipher = null;
        return res;
    }

    public static byte[] encrypt(byte[] salt, int iterations, char[] password, byte[] cleartext) throws NoSuchAlgorithmException, UnsupportedEncodingException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, InvalidAlgorithmParameterException, BadPaddingException {
        MessageDigest shaDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        byte[] pw = DataEssentials.toBytes(password, CHARSET_NAME);
        Arrays.fill(password, '\u0000');
        int i = 0;
        while (i < iterations) {
            byte[] salted = new byte[pw.length + salt.length];
            System.arraycopy(pw, 0, salted, 0, pw.length);
            System.arraycopy(salt, 0, salted, pw.length, salt.length);
            Arrays.fill(pw, (byte)0);
            shaDigest.reset();
            pw = shaDigest.digest(salted);
            Arrays.fill(salted, (byte)0);
            ++i;
        }
        byte[] key = new byte[16];
        byte[] iv = new byte[16];
        System.arraycopy(pw, 0, key, 0, 16);
        System.arraycopy(pw, 16, iv, 0, 16);
        Arrays.fill(pw, (byte)0);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, (Key)new SecretKeySpec(key, KEY_ALGORITHM), new IvParameterSpec(iv));
        Arrays.fill(key, (byte)0);
        Arrays.fill(iv, (byte)0);
        byte[] res = cipher.doFinal(cleartext);
        cipher = null;
        return res;
    }

    private AESEncryptor() {
    }
}

