/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.cosmology;

import info.thereisonlywe.core.essentials.LocaleEssentials;

public enum ZodiacAspect {
    CONJUNCTION(0.0),
    SEXTILE(60.0),
    SQUARE(90.0),
    TRINE(120.0),
    OPPOSITION(180.0),
    QUINCUNX(150.0),
    SEMI_SQUARE(45.0),
    SESQUI_QUADRATE(135.0),
    SEMI_SEXTILE(30.0),
    QUINTILE(72.0),
    BI_QUINTILE(144.0),
    SEPTILE(51.428571),
    BI_SEPTILE(102.857143),
    TRI_SEPTILE(154.285714),
    NOVILE(40.0),
    BI_NOVILE(80.0),
    QUAD_NOVILE(160.0),
    DECILE(36.0),
    TRI_DECILE(108.0),
    VIGINTILE(18.0),
    UN_DECILE(32.727272),
    BI_UN_DECILE(65.454545),
    TRI_UN_DECILE(98.181816),
    QUADRI_UN_DECILE(130.90909),
    QUINQUE_UN_DECILE(163.636363),
    SEMI_SEPTILE(25.714286),
    TRE_SEMI_SEPTILE(77.142858),
    QUIN_SEMI_SEPTILE(128.57143),
    SEMI_OCTILE(22.5),
    SESQUI_OCTILE(67.5),
    QUASQUI_QUADRATE(112.5),
    SEPTEMSE_DECIMAL(157.5),
    QUATTUOR_VIGINTILE(15.0),
    SQUILE(75.0),
    QUIN_DECILE(165.0);

    public final double angle;
    public static final ZodiacAspect[] ASPECTS;
    public static final ZodiacAspect[] ASPECTS_MAJOR;
    public static final ZodiacAspect[] ASPECTS_MINOR;
    public static final ZodiacAspect[] ASPECTS_HARMONIC;
    public static final ZodiacAspect[] ASPECTS_HARMONIC_7TH;
    public static final ZodiacAspect[] ASPECTS_HARMONIC_9TH;
    public static final ZodiacAspect[] ASPECTS_HARMONIC_10TH;
    public static final ZodiacAspect[] ASPECTS_HARMONIC_11TH;
    public static final ZodiacAspect[] ASPECTS_HARMONIC_14TH;
    public static final ZodiacAspect[] ASPECTS_HARMONIC_16TH;
    public static final ZodiacAspect[] ASPECTS_HARMONIC_24TH;

    static {
        ASPECTS = new ZodiacAspect[]{CONJUNCTION, SEXTILE, SQUARE, TRINE, OPPOSITION, QUINCUNX, SEMI_SQUARE, SESQUI_QUADRATE, SEMI_SEXTILE, QUINTILE, BI_QUINTILE, SEPTILE, BI_SEPTILE, TRI_SEPTILE, NOVILE, BI_NOVILE, QUAD_NOVILE, DECILE, TRI_DECILE, VIGINTILE, UN_DECILE, BI_UN_DECILE, TRI_UN_DECILE, QUADRI_UN_DECILE, QUINQUE_UN_DECILE, SEMI_SEPTILE, TRE_SEMI_SEPTILE, QUIN_SEMI_SEPTILE, SEMI_OCTILE, SESQUI_OCTILE, QUASQUI_QUADRATE, SEPTEMSE_DECIMAL, QUATTUOR_VIGINTILE, SQUILE, QUIN_DECILE};
        ASPECTS_MAJOR = new ZodiacAspect[]{CONJUNCTION, SEXTILE, SQUARE, TRINE, OPPOSITION};
        ASPECTS_MINOR = new ZodiacAspect[]{QUINCUNX, SEMI_SQUARE, SESQUI_QUADRATE, SEMI_SEXTILE, QUINTILE, BI_QUINTILE};
        ASPECTS_HARMONIC = new ZodiacAspect[]{SEPTILE, BI_SEPTILE, TRI_SEPTILE, NOVILE, BI_NOVILE, QUAD_NOVILE, DECILE, TRI_DECILE, VIGINTILE, UN_DECILE, BI_UN_DECILE, TRI_UN_DECILE, QUADRI_UN_DECILE, QUINQUE_UN_DECILE, SEMI_SEPTILE, TRE_SEMI_SEPTILE, QUIN_SEMI_SEPTILE, SEMI_OCTILE, SESQUI_OCTILE, QUASQUI_QUADRATE, SEPTEMSE_DECIMAL, QUATTUOR_VIGINTILE, SQUILE, QUIN_DECILE};
        ASPECTS_HARMONIC_7TH = new ZodiacAspect[]{SEPTILE, BI_SEPTILE, TRI_SEPTILE};
        ASPECTS_HARMONIC_9TH = new ZodiacAspect[]{NOVILE, BI_NOVILE, QUAD_NOVILE};
        ASPECTS_HARMONIC_10TH = new ZodiacAspect[]{DECILE, TRI_DECILE, VIGINTILE};
        ASPECTS_HARMONIC_11TH = new ZodiacAspect[]{UN_DECILE, BI_UN_DECILE, TRI_UN_DECILE, QUADRI_UN_DECILE, QUINQUE_UN_DECILE};
        ASPECTS_HARMONIC_14TH = new ZodiacAspect[]{SEMI_SEPTILE, TRE_SEMI_SEPTILE, QUIN_SEMI_SEPTILE};
        ASPECTS_HARMONIC_16TH = new ZodiacAspect[]{SEMI_OCTILE, SESQUI_OCTILE, QUASQUI_QUADRATE, SEPTEMSE_DECIMAL};
        ASPECTS_HARMONIC_24TH = new ZodiacAspect[]{QUATTUOR_VIGINTILE, SQUILE, QUIN_DECILE};
    }

    private ZodiacAspect(double angle) {
        this.angle = angle;
    }

    public String getName(String lang) {
        if (lang.equals("tr")) {
            if (this == CONJUNCTION) {
                return "Kavu\u015fum";
            }
            if (this == OPPOSITION) {
                return "Kar\u015f\u0131t";
            }
            if (this == TRINE) {
                return "\u00dc\u00e7gen";
            }
            if (this == SQUARE) {
                return "Kare";
            }
            if (this == SEXTILE) {
                return "Sekstil";
            }
            if (this == SEMI_SQUARE) {
                return "Yar\u0131m Kare";
            }
            if (this == SEMI_SEXTILE) {
                return "Yar\u0131m Sekstil";
            }
            return String.valueOf(this.angle) + " derece";
        }
        if (this == CONJUNCTION) {
            return "Conjunction";
        }
        if (this == OPPOSITION) {
            return "Opposition";
        }
        if (this == TRINE) {
            return "Trine";
        }
        if (this == SQUARE) {
            return "Square";
        }
        if (this == SEXTILE) {
            return "Sextile";
        }
        if (this == QUINCUNX) {
            return "Quincunx";
        }
        if (this == SEMI_SQUARE) {
            return "Semi-square";
        }
        if (this == SEMI_SEXTILE) {
            return "Semi-sextile";
        }
        if (this == SESQUI_QUADRATE) {
            return "Sesqui-quadrate";
        }
        if (this == QUINTILE) {
            return "Quintule";
        }
        if (this == BI_QUINTILE) {
            return "Bi-quintule";
        }
        return String.valueOf(this.angle) + " degrees";
    }

    public boolean is10thHarmonicAspect() {
        return this == DECILE || this == TRI_DECILE || this == VIGINTILE;
    }

    public boolean is11thHarmonicAspect() {
        return this == UN_DECILE || this == BI_UN_DECILE || this == TRI_UN_DECILE || this == QUADRI_UN_DECILE || this == QUINQUE_UN_DECILE;
    }

    public boolean is14thHarmonicAspect() {
        return this == SEMI_SEPTILE || this == TRE_SEMI_SEPTILE || this == QUIN_SEMI_SEPTILE;
    }

    public boolean is16thHarmonicAspect() {
        return this == SEMI_OCTILE || this == SESQUI_OCTILE || this == QUASQUI_QUADRATE || this == SEPTEMSE_DECIMAL;
    }

    public boolean is24thHarmonicAspect() {
        return this == QUATTUOR_VIGINTILE || this == SQUILE || this == QUIN_DECILE;
    }

    public boolean is7thHarmonicAspect() {
        return this == SEPTILE || this == BI_SEPTILE || this == TRI_SEPTILE;
    }

    public boolean is9thHarmonicAspect() {
        return this == NOVILE || this == BI_NOVILE || this == QUAD_NOVILE;
    }

    public boolean isHarmonicAspect() {
        return !this.isMajorAspect() && !this.isMinorAspect();
    }

    public boolean isMajorAspect() {
        return this == CONJUNCTION || this == OPPOSITION || this == SQUARE || this == TRINE || this == SEXTILE;
    }

    public boolean isMinorAspect() {
        return this == QUINCUNX || this == SEMI_SQUARE || this == SESQUI_QUADRATE || this == SEMI_SEXTILE || this == QUINTILE || this == BI_QUINTILE;
    }

    public String toString() {
        return this.getName(LocaleEssentials.LANGUAGE_DEFAULT);
    }
}

