/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.cosmology;

import info.thereisonlywe.core.cosmology.ZodiacSign;
import info.thereisonlywe.core.essentials.EsotericEssentials;

public class ZodiacDegree {
    public final double degree;
    public final ZodiacSign zodiacSign;
    public final double zodiacSignOffset;

    public ZodiacDegree(double deg) {
        this.degree = EsotericEssentials.normalizeZodiacDegree(deg);
        this.zodiacSign = EsotericEssentials.getZodiacSign(this.degree);
        this.zodiacSignOffset = this.degree - this.zodiacSign.degreeSpan.start;
    }

    public ZodiacDegree(ZodiacSign zs, double zsOffset) {
        this.degree = EsotericEssentials.normalizeZodiacDegree(zs.degreeSpan.start + zsOffset);
        this.zodiacSign = EsotericEssentials.getZodiacSign(this.degree);
        this.zodiacSignOffset = this.degree - this.zodiacSign.degreeSpan.start;
    }

    public ZodiacDegree plus(ZodiacDegree zd) {
        return new ZodiacDegree(EsotericEssentials.normalizeZodiacDegree(this.degree + zd.degree));
    }

    public ZodiacDegree plus(double deg) {
        return new ZodiacDegree(EsotericEssentials.normalizeZodiacDegree(this.degree + deg));
    }

    public ZodiacDegree minus(ZodiacDegree zd) {
        return new ZodiacDegree(EsotericEssentials.normalizeZodiacDegree(this.degree - zd.degree));
    }

    public ZodiacDegree minus(double deg) {
        return new ZodiacDegree(EsotericEssentials.normalizeZodiacDegree(this.degree - deg));
    }

    public ZodiacDegree getOppositeZodiacDegree() {
        if (this.degree >= 180.0) {
            return this.minus(180.0);
        }
        return this.plus(180.0);
    }

    public String toString() {
        int deg = (int)this.degree;
        int offset = (int)this.zodiacSignOffset;
        String s = this.degree == (double)deg ? String.valueOf(deg) + "\u00b0" : String.valueOf(this.degree) + "\u00b0";
        String b = String.valueOf(offset) + "\u00b0";
        return String.valueOf(s) + " (" + this.zodiacSign.toString() + " " + b + ")";
    }

    public String toZodiacString() {
        return String.valueOf(this.zodiacSign.toString()) + " " + (int)this.zodiacSignOffset + "\u00b0";
    }
}

