/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.cosmology;

import info.thereisonlywe.core.cosmology.Planet;
import info.thereisonlywe.core.essentials.LocaleEssentials;
import info.thereisonlywe.core.objects.CircularArray;
import info.thereisonlywe.core.objects.NumberRange;
import info.thereisonlywe.core.ontology.Element;
import info.thereisonlywe.core.ontology.Modality;

public enum ZodiacSign {
    ARIES(new NumberRange(0.0, 29.9999999999999), Element.FIRE, Modality.CARDINAL, Planet.MARS),
    TAURUS(new NumberRange(30.0, 59.9999999999999), Element.EARTH, Modality.FIXED, Planet.VENUS),
    GEMINI(new NumberRange(60.0, 89.9999999999999), Element.AIR, Modality.MUTABLE, Planet.MERCURY),
    CANCER(new NumberRange(90.0, 119.9999999999999), Element.WATER, Modality.CARDINAL, Planet.MOON),
    LEO(new NumberRange(120.0, 149.9999999999999), Element.FIRE, Modality.FIXED, Planet.SUN),
    VIRGO(new NumberRange(150.0, 179.9999999999999), Element.EARTH, Modality.MUTABLE, Planet.MERCURY),
    LIBRA(new NumberRange(180.0, 209.9999999999999), Element.AIR, Modality.CARDINAL, Planet.VENUS),
    SCORPIO(new NumberRange(210.0, 239.9999999999999), Element.WATER, Modality.FIXED, Planet.MARS),
    SAGITTARIUS(new NumberRange(240.0, 269.9999999999999), Element.FIRE, Modality.MUTABLE, Planet.JUPITER),
    CAPRICORN(new NumberRange(270.0, 299.9999999999999), Element.EARTH, Modality.CARDINAL, Planet.SATURN),
    AQUARIUS(new NumberRange(300.0, 329.9999999999999), Element.AIR, Modality.FIXED, Planet.SATURN),
    PISCES(new NumberRange(330.0, 359.9999999999999), Element.WATER, Modality.MUTABLE, Planet.JUPITER);

    public final NumberRange degreeSpan;
    public final Modality modality;
    public final Element element;
    public final Planet planet;

    private ZodiacSign(NumberRange range, Element element, Modality modality, Planet planet) {
        this.degreeSpan = range;
        this.modality = modality;
        this.element = element;
        this.planet = planet;
    }

    public String getName(String lang) {
        if (lang.equals("tr")) {
            if (this == ARIES) {
                return "Ko\u00e7";
            }
            if (this == TAURUS) {
                return "Bo\u011fa";
            }
            if (this == GEMINI) {
                return "\u0130kizler";
            }
            if (this == CANCER) {
                return "Yenge\u00e7";
            }
            if (this == LEO) {
                return "Aslan";
            }
            if (this == VIRGO) {
                return "Ba\u015fak";
            }
            if (this == LIBRA) {
                return "Terazi";
            }
            if (this == SCORPIO) {
                return "Akrep";
            }
            if (this == SAGITTARIUS) {
                return "Yay";
            }
            if (this == CAPRICORN) {
                return "O\u011flak";
            }
            if (this == AQUARIUS) {
                return "Kova";
            }
            if (this == PISCES) {
                return "Bal\u0131k";
            }
        } else {
            if (this == ARIES) {
                return "Aries";
            }
            if (this == TAURUS) {
                return "Taurus";
            }
            if (this == GEMINI) {
                return "Gemini";
            }
            if (this == CANCER) {
                return "Cancer";
            }
            if (this == LEO) {
                return "Leo";
            }
            if (this == VIRGO) {
                return "Virgo";
            }
            if (this == LIBRA) {
                return "Libra";
            }
            if (this == SCORPIO) {
                return "Scorpio";
            }
            if (this == SAGITTARIUS) {
                return "Sagittarius";
            }
            if (this == CAPRICORN) {
                return "Capricorn";
            }
            if (this == AQUARIUS) {
                return "Aquarius";
            }
            if (this == PISCES) {
                return "Pisces";
            }
        }
        return null;
    }

    public ZodiacSign getNext() {
        CircularArray<ZodiacSign> zs = new CircularArray<ZodiacSign>(ZodiacSign.values());
        zs.goTo(this);
        return zs.next();
    }

    public ZodiacSign getPrevious() {
        CircularArray<ZodiacSign> zs = new CircularArray<ZodiacSign>(ZodiacSign.values());
        zs.goTo(this);
        return zs.previous();
    }

    public String toString() {
        return this.getName(LocaleEssentials.LANGUAGE_DEFAULT);
    }
}

