/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.essentials;

import info.thereisonlywe.core.essentials.LanguageEssentials;
import info.thereisonlywe.core.essentials.LocaleEssentials;
import info.thereisonlywe.core.essentials.StringEssentials;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeEssentials {
    public static final long MINUTES_1 = 60000L;
    public static final long MINUTES_15 = 900000L;
    public static final long MINUTES_30 = 1800000L;
    public static final long MINUTES_45 = 2700000L;
    public static final long MINUTES_60 = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static final long MONTH = 2419200000L;

    public static String to12H(String txt) {
        return txt.replace("13:", "01:").replace("14:", "02:").replace("15:", "03:").replace("16:", "04:").replace("17:", "05:").replace("18:", "06:").replace("19:", "07:").replace("20:", "08:").replace("21:", "09:").replace("22:", "10:").replace("23:", "11:").replace("00:", "12:");
    }

    public static boolean isTimeInRange(String currentTime, String formattedTime1, String formattedTime2) {
        boolean result = false;
        try {
            if (formattedTime1.lastIndexOf(":") < 5) {
                formattedTime1 = String.valueOf(formattedTime1) + ":00";
            }
            if (formattedTime2.lastIndexOf(":") < 5) {
                formattedTime2 = String.valueOf(formattedTime2) + ":00";
            }
            if (currentTime.lastIndexOf(":") < 5) {
                currentTime = String.valueOf(currentTime) + ":00";
            }
            result = TimeEssentials.isInRange(formattedTime1, formattedTime2, currentTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static boolean isInRange(String argStartTime, String argEndTime, String argCurrentTime) throws ParseException {
        String reg = "^([0-1][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$";
        if (argStartTime.matches(reg) && argEndTime.matches(reg) && argCurrentTime.matches(reg)) {
            boolean valid = false;
            Date startTime = new SimpleDateFormat("HH:mm:ss").parse(argStartTime);
            Calendar startCalendar = Calendar.getInstance();
            startCalendar.setTime(startTime);
            Date currentTime = new SimpleDateFormat("HH:mm:ss").parse(argCurrentTime);
            Calendar currentCalendar = Calendar.getInstance();
            currentCalendar.setTime(currentTime);
            Date endTime = new SimpleDateFormat("HH:mm:ss").parse(argEndTime);
            Calendar endCalendar = Calendar.getInstance();
            endCalendar.setTime(endTime);
            if (currentTime.compareTo(endTime) < 0) {
                currentCalendar.add(5, 1);
                currentTime = currentCalendar.getTime();
            }
            if (startTime.compareTo(endTime) < 0) {
                startCalendar.add(5, 1);
                startTime = startCalendar.getTime();
            }
            if (currentTime.before(startTime)) {
                valid = false;
            } else {
                if (currentTime.after(endTime)) {
                    endCalendar.add(5, 1);
                    endTime = endCalendar.getTime();
                }
                valid = currentTime.before(endTime);
            }
            return valid;
        }
        throw new IllegalArgumentException("Not a valid time, expecting HH:MM:SS format");
    }

    public static String formatTime(long hour, long minute, long second) {
        while (second >= 60L) {
            second -= 60L;
            ++minute;
        }
        while (minute >= 60L) {
            minute -= 60L;
            ++hour;
        }
        String result = "";
        if (hour < 10L) {
            result = String.valueOf(result) + "0";
        }
        result = String.valueOf(result) + hour + ":";
        if (minute < 10L) {
            result = String.valueOf(result) + "0";
        }
        result = String.valueOf(result) + minute + ":";
        if (second < 10L) {
            result = String.valueOf(result) + "0";
        }
        result = String.valueOf(result) + second;
        return result;
    }

    public static String formatTime(long hour, long minute) {
        while (minute >= 60L) {
            minute -= 60L;
            ++hour;
        }
        String result = "";
        if (hour < 10L) {
            result = String.valueOf(result) + "0";
        }
        result = String.valueOf(result) + hour + ":";
        if (minute < 10L) {
            result = String.valueOf(result) + "0";
        }
        result = String.valueOf(result) + minute;
        return result;
    }

    public static String getCurrentTime() {
        Calendar c = Calendar.getInstance();
        return new SimpleDateFormat("hh:mm:ss").format(c.getTime());
    }

    public static String getCurrentDate() {
        return TimeEssentials.getDate(System.currentTimeMillis());
    }

    public static String getDate(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        String month = LanguageEssentials.isRightToLeftLanguage(LocaleEssentials.LANGUAGE_DEFAULT) ? "." + StringEssentials.addPaddingToNumber(String.valueOf(c.get(2) + 1), 2) + "." : " " + new DateFormatSymbols().getMonths()[c.get(2)] + " ";
        return String.valueOf(StringEssentials.addPaddingToNumber(String.valueOf(c.get(5)), 2)) + month + c.get(1);
    }

    public static String getDateAndTime(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        String month = LanguageEssentials.isRightToLeftLanguage(LocaleEssentials.LANGUAGE_DEFAULT) ? "." + StringEssentials.addPaddingToNumber(String.valueOf(c.get(2) + 1), 2) + "." : " " + new DateFormatSymbols().getMonths()[c.get(2)] + " ";
        return String.valueOf(StringEssentials.addPaddingToNumber(String.valueOf(c.get(5)), 2)) + month + c.get(1) + " | " + TimeEssentials.formatTime(c.get(11), c.get(12), c.get(13));
    }

    public static int getHour(String formattedTime) {
        return Integer.parseInt(new String(formattedTime.substring(0, 2)));
    }

    public static int getHourOffset(String baseT, String t) {
        return TimeEssentials.getHour(t) - TimeEssentials.getHour(baseT);
    }

    public static int getMinute(String formattedTime) {
        int index = formattedTime.indexOf(58);
        return Integer.parseInt(new String(formattedTime.substring(index + 1, index + 3)));
    }

    public static int getMinuteOffset(String baseT, String t) {
        return TimeEssentials.getMinute(t) - TimeEssentials.getMinute(baseT);
    }

    public static int getSecond(String formattedTime) {
        int index = formattedTime.lastIndexOf(58);
        return Integer.parseInt(new String(formattedTime.substring(index + 1, index + 3)));
    }

    public static int getSecondOffset(String baseT, String t) {
        return TimeEssentials.getSecond(t) - TimeEssentials.getSecond(baseT);
    }

    public static long getTimeDifference(String baseT, String t) {
        int second;
        int minute;
        int hour = TimeEssentials.getHourOffset(baseT, t);
        if (hour < 0) {
            hour += 12;
        }
        if ((minute = TimeEssentials.getMinuteOffset(baseT, t)) < 0) {
            minute += 60;
            --hour;
        }
        if ((second = TimeEssentials.getSecondOffset(baseT, t)) < 0) {
            second += 60;
            --minute;
        }
        return hour * 60 * 60 + minute * 60 + second;
    }

    public static String getTimeDifferenceAsString(String baseT, String t) {
        return TimeEssentials.formatTime(0L, 0L, TimeEssentials.getTimeDifference(baseT, t));
    }

    public static double GMTOffset(String tz) {
        if (TimeEssentials.inDST(tz)) {
            return TimeEssentials.rawGMTOffset(tz) + 1.0;
        }
        return TimeEssentials.rawGMTOffset(tz);
    }

    public static double GMTOffset(String tz, Date d) {
        if (TimeEssentials.inDST(tz, d)) {
            return TimeEssentials.rawGMTOffset(tz) + 1.0;
        }
        return TimeEssentials.rawGMTOffset(tz);
    }

    public static boolean inDST(String tz) {
        return TimeEssentials.inDST(tz, new Date());
    }

    public static boolean inDST(String tz, Date d) {
        return TimeZone.getTimeZone(tz).inDaylightTime(d);
    }

    public static double millisToYears(long m) {
        return (double)m / 3.1558464E10;
    }

    public static double rawGMTOffset(String tz) {
        int rawOffset = TimeZone.getTimeZone(tz).getRawOffset();
        int hour = rawOffset / 3600000;
        int minute = Math.abs(rawOffset / 60000) % 60;
        double result = (double)hour + (double)minute / 60.0;
        return result;
    }

    public static String roundSeconds(String formattedTime) {
        String[] tmp = formattedTime.split(":");
        if (tmp.length == 2) {
            return formattedTime;
        }
        int hrs = Integer.parseInt(tmp[0]);
        int mins = Integer.parseInt(tmp[1]);
        int secs = Integer.parseInt(tmp[2]);
        if (secs < 30) {
            return String.valueOf(tmp[0]) + ":" + tmp[1];
        }
        if (++mins >= 60) {
            mins -= 60;
            ++hrs;
        }
        return String.valueOf(StringEssentials.addPaddingToNumber(String.valueOf(hrs), 2)) + ":" + StringEssentials.addPaddingToNumber(String.valueOf(mins), 2);
    }
}

