/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.objects;

import info.thereisonlywe.core.objects.SequentialRange;

public class NumberRange
implements SequentialRange<Double> {
    public final Double start;
    public final Double end;
    public final Double mid;

    public NumberRange(Double start, Double end) {
        this.start = start;
        this.end = end;
        this.mid = (start + end) / 2.0;
    }

    @Override
    public boolean isInRange(Double k) {
        Double start = Math.min(this.start, this.end);
        Double end = Math.max(this.start, this.end);
        return k >= start && k <= end;
    }

    public String toString() {
        return "[" + this.start + ", " + this.end + "]";
    }

    public Double getRange() {
        Double start = Math.min(this.start, this.end);
        Double end = Math.max(this.start, this.end);
        return end - start;
    }
}

