/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.toolkit;

import info.thereisonlywe.core.essentials.StringEssentials;

public class AbjadCalculator {
    private static AbjadSystem abjadSystem = AbjadSystem.IBN_ARABI;

    public static AbjadSystem getAbjadSystem() {
        return abjadSystem;
    }

    public static int getDotlessAbjadValue(String s) {
        return AbjadCalculator.getDotlessAbjadValue(s, abjadSystem);
    }

    public static int getDotlessAbjadValue(String S, AbjadSystem abjadSystem) {
        S = StringEssentials.normalizeAleph(S);
        int total = 0;
        int i = 0;
        while (i < S.length()) {
            switch (S.charAt(i)) {
                case '\u0627': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0621': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u062f': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0647': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0648': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u062d': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0637': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0643': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0644': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0645': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0633': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0639': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0635': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0631': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
            }
            ++i;
        }
        return total;
    }

    public static int getDotsOnlyAbjadValue(String s) {
        return AbjadCalculator.getDotsOnlyAbjadValue(s, abjadSystem);
    }

    public static int getDotsOnlyAbjadValue(String S, AbjadSystem abjadSystem) {
        S = StringEssentials.normalizeAleph(S);
        int total = 0;
        int i = 0;
        while (i < S.length()) {
            switch (S.charAt(i)) {
                case '\u0628': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u062c': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0632': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0649': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u064a': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0646': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0641': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0642': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0634': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u062a': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u062b': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u062e': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0630': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0636': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u0638': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
                case '\u063a': {
                    total += AbjadCalculator.getTrueAbjadValue(String.valueOf(S.charAt(i)), abjadSystem);
                    break;
                }
            }
            ++i;
        }
        return total;
    }

    public static int getLiteralAbjadValue(String s) {
        return AbjadCalculator.getLiteralAbjadValue(s, abjadSystem);
    }

    public static int getLiteralAbjadValue(String s, AbjadSystem abjadSystem) {
        s = StringEssentials.normalizeAleph(s);
        int total = 0;
        String S = StringEssentials.removeNonTextCharacters(s);
        int i = 0;
        while (i < S.length()) {
            switch (S.charAt(i)) {
                case '\u0651': {
                    total += AbjadCalculator.getLiteralAbjadValue(String.valueOf(S.charAt(i - 1)), abjadSystem);
                    break;
                }
                case '\u0627': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0623\u0644\u0641", abjadSystem);
                    break;
                }
                case '\u0621': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0647\u0645\u0632", abjadSystem);
                    break;
                }
                case '\u0628': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0628\u0627\u0621", abjadSystem);
                    break;
                }
                case '\u062c': {
                    total += AbjadCalculator.getTrueAbjadValue("\u062c\u064a\u0645", abjadSystem);
                    break;
                }
                case '\u062f': {
                    total += AbjadCalculator.getTrueAbjadValue("\u062f\u0627\u0644", abjadSystem);
                    break;
                }
                case '\u0647': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0647\u0627\u0621", abjadSystem);
                    break;
                }
                case '\u0648': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0648\u0627\u0648", abjadSystem);
                    break;
                }
                case '\u0632': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0630\u0627\u0644", abjadSystem);
                    break;
                }
                case '\u062d': {
                    total += AbjadCalculator.getTrueAbjadValue("\u062d\u0627\u0621", abjadSystem);
                    break;
                }
                case '\u0637': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0637\u0627\u0621", abjadSystem);
                    break;
                }
                case '\u0649': {
                    total += AbjadCalculator.getTrueAbjadValue("\u064a\u0627\u0621", abjadSystem);
                    break;
                }
                case '\u064a': {
                    total += AbjadCalculator.getTrueAbjadValue("\u064a\u0627\u0621", abjadSystem);
                    break;
                }
                case '\u0643': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0643\u0627\u0641", abjadSystem);
                    break;
                }
                case '\u0644': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0644\u0627\u0645", abjadSystem);
                    break;
                }
                case '\u0645': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0645\u064a\u0645", abjadSystem);
                    break;
                }
                case '\u0646': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0646\u0648\u0646", abjadSystem);
                    break;
                }
                case '\u0633': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0633\u064a\u0646", abjadSystem);
                    break;
                }
                case '\u0639': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0639\u064a\u0646", abjadSystem);
                    break;
                }
                case '\u0641': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0641\u0627\u0621", abjadSystem);
                    break;
                }
                case '\u0635': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0635\u0627\u062f", abjadSystem);
                    break;
                }
                case '\u0642': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0642\u0627\u0641", abjadSystem);
                    break;
                }
                case '\u0631': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0631\u0627\u0621", abjadSystem);
                    break;
                }
                case '\u0634': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0634\u064a\u0646", abjadSystem);
                    break;
                }
                case '\u062a': {
                    total += AbjadCalculator.getTrueAbjadValue("\u062a\u0627\u0621", abjadSystem);
                    break;
                }
                case '\u062b': {
                    total += AbjadCalculator.getTrueAbjadValue("\u062b\u0627\u0621", abjadSystem);
                    break;
                }
                case '\u062e': {
                    total += AbjadCalculator.getTrueAbjadValue("\u062e\u0627\u0621", abjadSystem);
                    break;
                }
                case '\u0630': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0632\u0627\u064a", abjadSystem);
                    break;
                }
                case '\u0636': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0636\u0627\u062f", abjadSystem);
                    break;
                }
                case '\u0638': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0638\u0627\u0621", abjadSystem);
                    break;
                }
                case '\u063a': {
                    total += AbjadCalculator.getTrueAbjadValue("\u063a\u064a\u0646", abjadSystem);
                    break;
                }
            }
            ++i;
        }
        return total;
    }

    public static int getMod12AbjadValue(String s) {
        return AbjadCalculator.getMod12AbjadValue(s, abjadSystem);
    }

    public static int getMod12AbjadValue(String S, AbjadSystem abjadSystem) {
        S = StringEssentials.normalizeAleph(S);
        int total = 0;
        int i = 0;
        while (i < S.length()) {
            total += AbjadCalculator.getTrueAbjadValue(new String(S.substring(i, i + 1)), abjadSystem) % 12;
            ++i;
        }
        return total;
    }

    public static int getSingleDigitAbjadValue(String s) {
        return AbjadCalculator.getSingleDigitAbjadValue(s, abjadSystem);
    }

    public static int getSingleDigitAbjadValue(String S, AbjadSystem abjadSystem) {
        S = StringEssentials.normalizeAleph(S);
        int total = 0;
        int i = 0;
        while (i < S.length()) {
            int temp = AbjadCalculator.getTrueAbjadValue(new String(S.substring(i, i + 1)), abjadSystem);
            while (temp >= 10) {
                temp /= 10;
            }
            total += temp;
            ++i;
        }
        return total;
    }

    public static int getTrueAbjadValue(String s) {
        return AbjadCalculator.getTrueAbjadValue(s, abjadSystem);
    }

    public static int getTrueAbjadValue(String S, AbjadSystem abjadSystem) {
        S = StringEssentials.normalizeAleph(S);
        int total = 0;
        int i = 0;
        while (i < S.length()) {
            switch (S.charAt(i)) {
                case '\u0627': {
                    ++total;
                    break;
                }
                case '\u0621': {
                    ++total;
                    break;
                }
                case '\u0628': {
                    total += 2;
                    break;
                }
                case '\u062c': {
                    total += 3;
                    break;
                }
                case '\u062f': {
                    total += 4;
                    break;
                }
                case '\u0647': {
                    total += 5;
                    break;
                }
                case '\u0648': {
                    total += 6;
                    break;
                }
                case '\u0632': {
                    total += 7;
                    break;
                }
                case '\u062d': {
                    total += 8;
                    break;
                }
                case '\u0637': {
                    total += 9;
                    break;
                }
                case '\u0649': {
                    total += 10;
                    break;
                }
                case '\u064a': {
                    total += 10;
                    break;
                }
                case '\u0643': {
                    total += 20;
                    break;
                }
                case '\u0644': {
                    total += 30;
                    break;
                }
                case '\u0645': {
                    total += 40;
                    break;
                }
                case '\u0646': {
                    if (abjadSystem == AbjadSystem.IBN_ARABI) {
                        total += 55;
                        break;
                    }
                    total += 50;
                    break;
                }
                case '\u0633': {
                    if (abjadSystem == AbjadSystem.EASTERN) {
                        total += 60;
                        break;
                    }
                    if (abjadSystem == AbjadSystem.WESTERN) {
                        total += 300;
                        break;
                    }
                    if (abjadSystem != AbjadSystem.IBN_ARABI) break;
                    total += 303;
                    break;
                }
                case '\u0639': {
                    total += 70;
                    break;
                }
                case '\u0641': {
                    if (abjadSystem == AbjadSystem.IBN_ARABI) {
                        total += 88;
                        break;
                    }
                    total += 80;
                    break;
                }
                case '\u0635': {
                    if (abjadSystem == AbjadSystem.EASTERN) {
                        total += 90;
                        break;
                    }
                    total += 60;
                    break;
                }
                case '\u0642': {
                    total += 100;
                    break;
                }
                case '\u0631': {
                    total += 200;
                    break;
                }
                case '\u0634': {
                    if (abjadSystem == AbjadSystem.EASTERN) {
                        total += 300;
                        break;
                    }
                    total += 1000;
                    break;
                }
                case '\u062a': {
                    if (abjadSystem == AbjadSystem.IBN_ARABI) {
                        total += 404;
                        break;
                    }
                    total += 400;
                    break;
                }
                case '\u062b': {
                    if (abjadSystem == AbjadSystem.IBN_ARABI) {
                        total += 505;
                        break;
                    }
                    total += 500;
                    break;
                }
                case '\u062e': {
                    total += 600;
                    break;
                }
                case '\u0630': {
                    if (abjadSystem == AbjadSystem.IBN_ARABI) {
                        total += 707;
                        break;
                    }
                    total += 700;
                    break;
                }
                case '\u0636': {
                    if (abjadSystem == AbjadSystem.EASTERN) {
                        total += 800;
                        break;
                    }
                    total += 90;
                    break;
                }
                case '\u0638': {
                    if (abjadSystem == AbjadSystem.EASTERN) {
                        total += 900;
                        break;
                    }
                    if (abjadSystem == AbjadSystem.WESTERN) {
                        total += 800;
                        break;
                    }
                    if (abjadSystem != AbjadSystem.IBN_ARABI) break;
                    total += 808;
                    break;
                }
                case '\u063a': {
                    if (abjadSystem == AbjadSystem.EASTERN) {
                        total += 1000;
                        break;
                    }
                    total += 900;
                    break;
                }
            }
            ++i;
        }
        return total;
    }

    public static void setAbjadSystem(AbjadSystem abjadSystem) {
        AbjadCalculator.abjadSystem = abjadSystem;
    }

    private static int getNumberAbjadValue(String s) {
        return AbjadCalculator.getNumberAbjadValue(s, abjadSystem);
    }

    private static int getNumberAbjadValue(String s, AbjadSystem abjadSystem) {
        s = StringEssentials.normalizeAleph(s);
        int total = 0;
        String S = StringEssentials.removeNonTextCharacters(s);
        S = StringEssentials.removeDiacritics(S);
        S = S.replace("\u0649", "\u064a");
        int i = 0;
        while (i < S.length()) {
            switch (S.charAt(i)) {
                case '\u0627': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0648\u0627\u062d\u062f", abjadSystem);
                    break;
                }
                case '\u0621': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0648\u0627\u062d\u062f", abjadSystem);
                    break;
                }
                case '\u0628': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0627\u062b\u0646\u0627\u0646", abjadSystem);
                    break;
                }
                case '\u062c': {
                    total += AbjadCalculator.getTrueAbjadValue("\u062b\u0644\u0627\u062b\u0629", abjadSystem);
                    break;
                }
                case '\u062f': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0623\u0631\u0628\u0639\u0629", abjadSystem);
                    break;
                }
                case '\u0647': {
                    total += AbjadCalculator.getTrueAbjadValue("\u062e\u0645\u0633\u0629", abjadSystem);
                    break;
                }
                case '\u0648': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0633\u062a\u0629", abjadSystem);
                    break;
                }
                case '\u0632': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0633\u0628\u0639\u0629", abjadSystem);
                    break;
                }
                case '\u062d': {
                    total += AbjadCalculator.getTrueAbjadValue("\u062b\u0645\u0627\u0646\u064a\u0629", abjadSystem);
                    break;
                }
                case '\u0637': {
                    total += AbjadCalculator.getTrueAbjadValue("\u062a\u0633\u0639\u0629", abjadSystem);
                    break;
                }
                case '\u0649': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0639\u0634\u0631\u0629", abjadSystem);
                    break;
                }
                case '\u064a': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0639\u0634\u0631\u0629", abjadSystem);
                    break;
                }
                case '\u0643': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0639\u0634\u0631\u0648\u0646", abjadSystem);
                    break;
                }
                case '\u0644': {
                    total += AbjadCalculator.getTrueAbjadValue("\u062b\u0644\u0627\u062b\u0648\u0646", abjadSystem);
                    break;
                }
                case '\u0645': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0623\u0631\u0628\u0639\u0648\u0646", abjadSystem);
                    break;
                }
                case '\u0646': {
                    if (abjadSystem == AbjadSystem.IBN_ARABI) {
                        AbjadCalculator.getTrueAbjadValue("\u062e\u0645\u0633 \u0648\u062e\u0645\u0633\u064a\u0646", abjadSystem);
                        break;
                    }
                    total += AbjadCalculator.getTrueAbjadValue("\u062e\u0645\u0633\u0648\u0646", abjadSystem);
                    break;
                }
                case '\u0633': {
                    if (abjadSystem == AbjadSystem.EASTERN) {
                        total += AbjadCalculator.getTrueAbjadValue("\u0633\u062a\u0648\u0646", abjadSystem);
                        break;
                    }
                    if (abjadSystem == AbjadSystem.WESTERN) {
                        total += AbjadCalculator.getTrueAbjadValue("\u062b\u0644\u0627\u062b \u0645\u0626\u0629", abjadSystem);
                        break;
                    }
                    if (abjadSystem != AbjadSystem.IBN_ARABI) break;
                    total += 303;
                    break;
                }
                case '\u0639': {
                    total += AbjadCalculator.getTrueAbjadValue("\u0633\u0628\u0639\u0648\u0646", abjadSystem);
                    break;
                }
                case '\u0641': {
                    total += AbjadCalculator.getTrueAbjadValue("\u062b\u0645\u0627\u0646\u0648\u0646", abjadSystem);
                    break;
                }
                case '\u0635': {
                    if (abjadSystem == AbjadSystem.EASTERN) {
                        total += AbjadCalculator.getTrueAbjadValue("\u062a\u0633\u0639\u0648\u0646", abjadSystem);
                        break;
                    }
                    total += AbjadCalculator.getTrueAbjadValue("\u0633\u062a\u0648\u0646", abjadSystem);
                    break;
                }
                case '\u0642': {
                    total += 100;
                    break;
                }
                case '\u0631': {
                    total += 200;
                    break;
                }
                case '\u0634': {
                    if (abjadSystem == AbjadSystem.EASTERN) {
                        total += 300;
                        break;
                    }
                    total += 1000;
                    break;
                }
                case '\u062a': {
                    total += 400;
                    break;
                }
                case '\u062b': {
                    total += 500;
                    break;
                }
                case '\u062e': {
                    total += 600;
                    break;
                }
                case '\u0630': {
                    total += 700;
                    break;
                }
                case '\u0636': {
                    if (abjadSystem == AbjadSystem.EASTERN) {
                        total += 800;
                        break;
                    }
                    total += 90;
                    break;
                }
                case '\u0638': {
                    if (abjadSystem == AbjadSystem.EASTERN) {
                        total += 900;
                        break;
                    }
                    if (abjadSystem == AbjadSystem.WESTERN) {
                        total += 800;
                        break;
                    }
                    if (abjadSystem != AbjadSystem.IBN_ARABI) break;
                    total += 808;
                    break;
                }
                case '\u063a': {
                    if (abjadSystem == AbjadSystem.EASTERN) {
                        total += AbjadCalculator.getTrueAbjadValue("\u0627\u0644\u0641", abjadSystem);
                        break;
                    }
                    total += 900;
                    break;
                }
            }
            ++i;
        }
        return total;
    }

    public static enum AbjadSystem {
        EASTERN,
        WESTERN,
        IBN_ARABI;

    }
}

