/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.core.toolkit;

public class Validator {
    public static boolean isNullLocation(double latitude, double longitude) {
        return latitude == 0.0 && longitude == 0.0;
    }

    public static boolean isValidAltitude(double altitudeInMeters) {
        if (!Validator.isValidDouble(altitudeInMeters)) {
            return false;
        }
        if (altitudeInMeters > 8848.0) {
            return false;
        }
        return !(altitudeInMeters < -424.0);
    }

    public static boolean isValidDouble(double d) {
        return !Double.isNaN(d) && !Double.isInfinite(d) && d != Double.NEGATIVE_INFINITY && d != Double.POSITIVE_INFINITY;
    }

    public static boolean isValidInt(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isValidLocation(double latitude, double longitude, boolean allowHighLats, boolean allowNullLocation) {
        if (allowNullLocation) {
            return Validator.isValidLocation(latitude, longitude, allowHighLats);
        }
        if (!Validator.isNullLocation(latitude, longitude)) {
            return Validator.isValidLocation(latitude, longitude, allowHighLats);
        }
        return false;
    }

    public static boolean isValidLocation(double latitude, double longitude, boolean allowHighLats) {
        if (!Validator.isValidDouble(latitude) || !Validator.isValidDouble(longitude)) {
            return false;
        }
        if (allowHighLats) {
            return latitude >= -90.0 && latitude <= 90.0 && longitude >= -180.0 && longitude <= 180.0;
        }
        return latitude > -60.0 && latitude < 60.0 && longitude >= -180.0 && longitude <= 180.0;
    }

    public static boolean isValidLocation(double latitude, double longitude) {
        return Validator.isValidLocation(latitude, longitude, true);
    }

    public static boolean isValidTimeZone(double UTC) {
        if (!Validator.isValidDouble(UTC)) {
            return false;
        }
        return UTC >= -12.0 && UTC <= 14.0;
    }

    public static boolean isNumeric(String str) {
        if (str == null || str.equals("")) {
            return false;
        }
        boolean val = str.matches("[+-]?\\d*(\\.\\d+)?");
        if (!val) {
            return str.equals("0.");
        }
        return val;
    }

    public static boolean isASCII(String str) {
        return str.matches("^\\p{ASCII}*$");
    }
}

