/*
 * Decompiled with CFR 0.152.
 */
package info.thereisonlywe.yachtregisterer;

import info.thereisonlywe.core.essentials.IOEssentials;
import info.thereisonlywe.core.essentials.StringEssentials;
import info.thereisonlywe.yachtregisterer.MainUI;
import info.thereisonlywe.yachtregisterer.Values;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.NetworkInterface;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.MatteBorder;

public class AuthenticationDialog
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private JPasswordField passwordField;
    private JLabel lblNewLabel;

    public AuthenticationDialog(final boolean managerLogin) {
        this.setAlwaysOnTop(true);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setTitle("Yacht Registerer | Giri\u015f");
        this.setBounds(100, 100, 235, 60);
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new MatteBorder(1, 1, 1, 1, new Color(0, 0, 0)));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        this.lblNewLabel = new JLabel(managerLogin ? "  Y\u00f6netici \u015eifresini Girin  " : "  \u015eifreyi Girin  ");
        this.lblNewLabel.setFont(new Font("Segoe UI", this.lblNewLabel.getFont().getStyle() | 1, this.lblNewLabel.getFont().getSize() + 1));
        this.contentPanel.add((Component)this.lblNewLabel, "West");
        this.passwordField = new JPasswordField();
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                this.checkPassword(AuthenticationDialog.this.passwordField.getPassword());
            }

            private void checkPassword(char[] text) {
                try {
                    if (managerLogin) {
                        if (Arrays.equals(Values.encryptor(Values.tday, true), text) || Arrays.equals(text, Values.encryptor(new String(Values.masterPW), false))) {
                            Values.isManager = true;
                            MainUI.mnNewMenu.setEnabled(true);
                            MainUI.mntmYneticiGirii.setText("Y\u00f6netici \u00c7\u0131k\u0131\u015f\u0131");
                            MainUI.mntmYneticiGirii.setToolTipText("Y\u00f6netici giri\u015fi yap\u0131ld\u0131");
                            MainUI.mnNewMenu.setEnabled(true);
                            MainUI.updatePrivileges();
                            AuthenticationDialog.this.setVisible(false);
                            if (Values.yachts.size() >= 50 && Values.backupSession && Values.isManager) {
                                Values.takeBackup(Values.getBackupFile());
                            }
                            AuthenticationDialog.this.dispose();
                        }
                    } else if (String.valueOf(text).equals("demo")) {
                        Values.isDemo = true;
                        Values.isManager = true;
                        Values.PW = Values.encryptor(String.valueOf(text), true);
                        Values.masterPW = Values.encryptor(String.valueOf(text), true);
                        Values.isNewInstallation = true;
                    } else if (Values.file.exists()) {
                        char[] txt = (char[])text.clone();
                        char[] s = Values.encryptor(IOEssentials.readString(Values.file), txt, false);
                        if (s != null && s.length > 0 && !Values.isOnHold) {
                            Values.PW = Values.encryptor(String.valueOf(text), true);
                            long l = Files.readAttributes(Values.file.toPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime().toMillis();
                            String[] k = new String(s).split(Pattern.quote(")|("));
                            if (!k[0].equals("3456712") && l != Long.parseLong(k[0]) && !Values.isManager) {
                                JOptionPane.showMessageDialog(AuthenticationDialog.this, StringEssentials.multiLine("Veritaban\u0131n\u0131n kopyaland\u0131\u011f\u0131 tespit edildi! Uygulama \u015fimdi sonlanacak. E\u011fer yede\u011finiz varsa, yedek dosyas\u0131n\u0131n ad\u0131n\u0131 eski dosyanin ismiyle (Yacht Registerer.db) de\u011fi\u015ftirip kullanabilirsiniz. \u015eayet elinizde hi\u00e7 \u00f6zg\u00fcn veritaban\u0131 yoksa info@thereisonlywe.info adresine ileti g\u00f6nderip yard\u0131m isteyebilirsiniz.", 45));
                                System.exit(1);
                                return;
                            }
                            Values.doc = Values.encryptor(String.valueOf(l), true);
                            k[0] = null;
                            Values.masterPW = Values.encryptor(k[2], true);
                            k[2] = null;
                            Values.importSettings(k[3]);
                            k[3] = null;
                            Values.importYachts(k[4]);
                            k[4] = null;
                            StringBuilder sb = new StringBuilder();
                            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                            while (nis.hasMoreElements()) {
                                NetworkInterface ni = nis.nextElement();
                                sb.append(ni.getDisplayName());
                                sb.append("#:#");
                            }
                            if (!Values.isManager && !Arrays.equals(Values.PW, Values.masterPW) && StringEssentials.getSimilarity(sb.toString(), k[1]) < 0.95) {
                                Values.isOnHold = true;
                                AuthenticationDialog.this.lblNewLabel.setText("  Y\u00f6netici \u015eifresini Girin  ");
                                return;
                            }
                            Values.cs = Values.encryptor(sb.toString(), true);
                            if (Arrays.equals(Values.masterPW, Values.PW)) {
                                Values.isManager = true;
                            }
                            Values.isAuthenticated = true;
                            k[1] = null;
                        } else if (!Values.isManager && (Values.isOnHold || s == null || s.length <= 0)) {
                            if (Arrays.equals(Values.encryptor(Values.tday, true), text)) {
                                Toolkit.getDefaultToolkit().beep();
                                Values.isManager = true;
                                Values.isOnHold = false;
                                if (Values.masterPW != null) {
                                    Values.isAuthenticated = true;
                                } else {
                                    AuthenticationDialog.this.lblNewLabel.setText("   | \u015eifreyi Girin |   ");
                                }
                            } else if (Values.isOnHold && Values.masterPW != null && Arrays.equals(text, Values.encryptor(new String(Values.masterPW), false))) {
                                StringBuilder sb = new StringBuilder();
                                Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                                while (nis.hasMoreElements()) {
                                    NetworkInterface ni = nis.nextElement();
                                    sb.append(ni.getDisplayName());
                                    sb.append("#:#");
                                }
                                Values.cs = Values.encryptor(sb.toString(), true);
                                long l = Files.readAttributes(Values.file.toPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime().toMillis();
                                Values.doc = Values.encryptor(String.valueOf(l), true);
                                Values.isManager = true;
                                Values.isAuthenticated = true;
                            }
                        }
                    } else if (Arrays.equals(Values.encryptor(Values.tday, true), text)) {
                        StringBuilder sb = new StringBuilder();
                        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                        while (nis.hasMoreElements()) {
                            NetworkInterface ni = nis.nextElement();
                            sb.append(ni.getDisplayName());
                            sb.append("#:#");
                        }
                        Values.cs = Values.encryptor(sb.toString(), true);
                        Values.PW = Values.encryptor(String.valueOf(text), true);
                        Values.masterPW = Values.encryptor(String.valueOf(text), true);
                        Values.isManager = true;
                        Values.isNewInstallation = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.passwordField.setFont(new Font("Segoe UI", this.passwordField.getFont().getStyle(), this.passwordField.getFont().getSize() + 2));
        this.contentPanel.add((Component)this.passwordField, "Center");
    }

    public AuthenticationDialog() {
        this(false);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent arg0) {
            }

            @Override
            public void windowIconified(WindowEvent arg0) {
            }

            @Override
            public void windowDeiconified(WindowEvent arg0) {
            }

            @Override
            public void windowDeactivated(WindowEvent arg0) {
            }

            @Override
            public void windowClosing(WindowEvent arg0) {
            }

            @Override
            public void windowClosed(WindowEvent arg0) {
                if (!Values.isAuthenticated && !Values.isNewInstallation) {
                    System.exit(0);
                }
            }

            @Override
            public void windowActivated(WindowEvent arg0) {
            }
        });
    }
}

